// hlavickove subory *******************************************************
#include "../includes.h"
// vlastny .h subor
#include "avatar.h"

// konstruktor *************************************************************
CAvatar::CAvatar()
{
 reset(); // reset parametrov Avatara
}

// destruktor **************************************************************
CAvatar::~CAvatar()
{

}

// inicializacia Avatara ***************************************************
void CAvatar::init(void)
{
 glMatrixMode(GL_PROJECTION); // vyber projekcnej matice
 glLoadIdentity();            // zresetovanie projekcnej matice

 if (scr_h==0) scr_h=1;
 // nastavenie perspektivneho premietania
 // fov - zorny uhol pohladu, W/H - aspect - pomer sirky a vysky kresliacej plochy
 // viewnear - minimalny dohlad, viewfar - maximalny dohlad
 pr_mat.perspective(fov,(GLfloat) scr_w/(GLfloat) scr_h,viewnear,viewfar);

 // INFO: bez shaderov
 gluPerspective(fov,(GLfloat) scr_w/(GLfloat) scr_h,viewnear,viewfar);

 // nastavenie rozmerov OpenGL kresliacej plochy
 glViewport(0,0,scr_w,scr_h);

 // TRANSFORMUJEME SCENU, NIE KAMERU!
 glMatrixMode(GL_MODELVIEW); // vyber modelview matice
 glLoadIdentity();           // zresetovanie modelview matice
}

// reset parametrov Avatara ************************************************
void CAvatar::reset(void)
{
 fov=60.0f;                      // zorny uhol pohladu
 viewnear=0.1f; viewfar=1000.0f; // minimalny a maximalny dohlad

 mv_mat.identity(); // nastavenie jednotkovej transformacnej matice

 actpos.set(0.0f,-2.0f,-10.0f); // aktualna poloha Avatara

 dmove.set(0.0f,0.0f,0.0f); // zmena polohy a natocenia
 drotate.set(0.0f,0.0f,0.0f);
}

// nastavenie prirastkov pre zmenu polohy Avatara **************************
void CAvatar::setmovxyz(void)
{
 // hodnoty su upravene pre dosiahnutie realnejsieho vnemu
 dmove.set(-(goRight-goLeft)*10.0f,    // vlavo a vpravo
           -(goUp-goDown)*10.0f,       // hore a dole
           -(goForward-goBack)*10.0f); // dopredu a dozadu

 // zrusenie dalsieho mozneho posunu
 goForward=0.0f; goBack=0.0f; goUp=0.0f; goDown=0.0f; goRight=0.0f; goLeft=0.0f;
}

// nastavenie prirastkov pre zmenu natocenia Avatara ***********************
void CAvatar::setrotab(GLfloat A,GLfloat B)
{
 // hodnoty su upravene pre dosiahnutie realnejsieho vnemu
 drotate.set(A/400.0f,B/400.0f,drotate.z);
}

// aktualizacia parametrov Avatara *****************************************
/*
 rychlost  v=s/t [m/s]  draha  s=vt [m]
           v=at [m/s]
 zrychlenie             a=s/t2 [m/s2]
 gravitacne zrychlenie  g=v/t [m/s2], g na Zemi=9.81 m/s2
                        g=s/t2  draha  s=gt2 [m]
*/
void CAvatar::update(void)
{
 // reset posunu
 mv_mat[12]=0.0f; mv_mat[13]=0.0f; mv_mat[14]=0.0f;

 // vypocet rotacie Avatara
 mv_mat.rotate(drotate.y,mv_mat[0],mv_mat[4],mv_mat[8]);  // okolo vektora 0 4 8
 mv_mat.rotate(drotate.x,mv_mat[1],mv_mat[5],mv_mat[9]);  // okolo vektora 1 5 9
 mv_mat.rotate(drotate.z,mv_mat[2],mv_mat[6],mv_mat[10]); // okolo vektora 2 6 10

 // vypocet posunu Avatara - zavisly na FPS
 // dmove predstavuje konstantnu rychlost v
 // dTime predstavuje t
 // draha s = v * t
 p.set(dmove.x*dTime,dmove.y*dTime,dmove.z*dTime);
 q.set(mv_mat[0]*p.x+mv_mat[1]*p.y-mv_mat[2] *p.z,
       mv_mat[4]*p.x+mv_mat[5]*p.y-mv_mat[6] *p.z,
       mv_mat[8]*p.x+mv_mat[9]*p.y-mv_mat[10]*p.z);
 // nastavenie novej polohy
 actpos+=q;
 mv_mat.translate(actpos.x,actpos.y,actpos.z);

 drotate.set(0.0f,0.0f,0.0f);
/*
 // INFO: modelview matica
 printf("%.2f %.2f %.2f %.2f\n",mv_mat[0],mv_mat[4],mv_mat[8],mv_mat[12]);
 printf("%.2f %.2f %.2f %.2f\n",mv_mat[1],mv_mat[5],mv_mat[9],mv_mat[13]);
 printf("%.2f %.2f %.2f %.2f\n",mv_mat[2],mv_mat[6],mv_mat[10],mv_mat[14]);
 printf("%.2f %.2f %.2f %.2f\n",mv_mat[3],mv_mat[7],mv_mat[11],mv_mat[15]);
 printf("\n");
*/
}
