#ifndef _BUTTON_H_
#define _BUTTON_H_

#define CHARNUM 8 // maximalny pocet znakov tlacidla

// trieda premennych a funkcii pre pracu s tlacidlami menu
class CButton {
public:
 CButton() { // konstruktor
  pos.set(0.0f,0.0f,0.0f);
  w=1.0f; h=1.0f;
  tscale_x=1.0f; tscale_y=1.0f;
  cnum=4;

  data=0.0f; d=0.0f;    // ciselny udaj tlacidla
  range.set(0.0f,1.0f); // povoleny rozsah ciselneho udaju tlacidla

  loopi(CHARNUM) buf[i]=' '; buf[CHARNUM-1]='\0'; // pomocny zasobnik pre znaky
 };
 // inicializacia tlacidla
 void init(vec3 P,float W,float H) {
  pos=P; w=W; h=H; // poloha, sirka, vyska tlacidla
 }
 // nastavenie velkosti textu
 void set_tscale(float SX,float SY) {
  if (SX>0.0f) tscale_x=SX; if (SY>0.0f) tscale_y=SY;
 }
 // nastavenie poctu zobrazovanych znakov
 void set_cnum(int N) { if ((N+1)<CHARNUM) cnum=N; }
 // nastavenie povoleneho rozsahu ciselneho udaju tlacidla
 void set_range(float A,float B) { range.set(A,B); }
 // mys je/nie je na tlacidle
 bool on_button(float X,float Y) {
  return(X>pos.x && X<(pos.x+w) && Y>pos.y && Y<(pos.y+h));
 }
 // nastavenie ciselneho udaju tlacidla
 void set_data(float D) {
  d=D;
  if (d>=range.x && d<=range.y) { data=d; sprintf(buf,"%.2f",data); }
 }
 // aktualizacia ciselneho udaju tlacidla
 void update(float D) {
  d=data; d+=D;
  if (d>=range.x && d<=range.y) { data=d; sprintf(buf,"%.2f",data); }
 }
 // ziskanie ciselneho udaju tlacidla
 float get_data(void) { return(data); }
 // vykreslenie tlacidla
 void draw(void);
private:
 vec3 pos;  // poloha tlacidla
 float w,h; // sirka, vyska tlacidla

 float tscale_x,tscale_y; // velkost textu
 int cnum; // pocet zobrazovanych znakov

 float data,d; // ciselny udaj tlacidla, pomocna premenna
 vec2 range;   // povoleny rozsah ciselneho udaju tlacidla

 char buf[CHARNUM]; // pomocny zasobnik pre znaky
};

#endif
