// hlavickove subory *******************************************************
#include "../includes.h"
// vlastny .h subor
#include "math3d.h"

void Cmath3d::calc_tbn(vec3 V0,vec3 V1,vec3 V2,vec2 V0T,vec2 V1T,vec2 V2T,
                       vec3 &T,vec3 &B,vec3 &N)
{
 // vypocet N
 v1v0=V1-V0; v2v0=V2-V0;
 N=v1v0.cross(v2v0); N.normalize();

 // vypocet T a B pre TANGENT space
 t1t0=V1T-V0T; t2t0=V2T-V0T;

 // recip=((t1.x-t0.x)*(t2.y-t0.y)-(t1.y-t0.y)*(t2.x-t0.x))
 recip=t1t0.x*t2t0.y-t1t0.y*t2t0.x;

 if (recip!=0.0f) {
  recip=1.0f/recip;
  //    (v1-v0).(t2-t0)y-(v2-v0).(t1-t0)y
  // T=-----------------------------------
  //                 recip
  T=(v1v0*t2t0.y-v2v0*t1t0.y)*recip; T.normalize();

  //    (v2-v0).(t1-t0)x-(v1-v0).(t2-t0)x
  // B=-----------------------------------
  //                 recip
  B=(v2v0*t1t0.x-v1v0*t2t0.x)*recip; B.normalize();
 }
}
