// hlavickove subory *******************************************************
#include "../includes.h"
// vlastny .h subor
#include "shader.h"

CShader base_shader;  // zakladny shader
CShader light_shader; // shader pre osvetlenie
CShader brick_shader; // shader - tehly

// nacitanie obsahu textoveho suboru ***************************************
char *CShader::TextFileRead(const char *FNAME)
{
 FILE *f_p=NULL;
 char *f_content=NULL;
 int f_size=0;

 // ziskanie velkosti suboru
 f_p=fopen(FNAME,"rb");
 if (f_p==NULL) { printf("Nemozno otvorit subor: %s!\n",FNAME); return(NULL); }
 fseek(f_p,0,SEEK_END);
 f_size=ftell(f_p);
 fclose(f_p);

 // ak subor nie je prazdny
 if (f_size>0) {
  f_p=fopen(FNAME,"rt");
  // nacitanie obsahu textoveho suboru
  f_content=new char[f_size+1];
  if (f_content==NULL) { printf("Nemozno vyhradit pamat!\n"); fclose(f_p); return(NULL); }
  f_size=(int) fread(f_content,sizeof(char),f_size,f_p);
  f_content[f_size]='\0';
  fclose(f_p);
 }
 else { printf("Subor je prazdny!\n"); return(NULL); }

 return(f_content);
}

// konstruktor *************************************************************
CShader::CShader()
{
 vertex=0; fragment=0; program=0;
}

// destruktor **************************************************************
CShader::~CShader()
{
#ifdef OGL20
 if (vertex && fragment && program) {
  // odpojenie shaderov
  glDetachShader(program,vertex); glDetachShader(program,fragment);
  // zrusenie shader objektov
  glDeleteShader(vertex); glDeleteShader(fragment);
  // zrusenie program objektu
  glDeleteProgram(program);
 }
#else
 if (vertex && fragment && program) {
  glDetachObjectARB(program,vertex); glDetachObjectARB(program,fragment);
  glDeleteObjectARB(vertex); glDeleteObjectARB(fragment);
  glDeleteObjectARB(program);
 }
#endif
}

// inicializacia pouzitia shaderov *****************************************
int CShader::init(void)
{
 printf("GLSL init...\n");

#ifdef OGL20
 if (glewIsSupported("GL_VERSION_2_0")) printf("using OpenGL 2.0\n");
 else { printf("OpenGL 2.0 not supported\n"); return(1); }
#else
 if (GLEW_ARB_vertex_shader && GLEW_ARB_fragment_shader) printf("using ARB extensions\n");
 else { printf("ARB extensions not supported\n"); return(1); }
#endif

 return(0);
}

// nacitanie kodu GLSL vertex & fragment shadera ***************************
int CShader::load(const char *VP,const char *FP)
{
 char *vp_src=TextFileRead(VP); // kod vertex programu
 char *fp_src=TextFileRead(FP); // kod fragment programu

 if (vp_src==NULL || fp_src==NULL) {
  printf("Nemozno nacitat kod GLSL shaderov!\n");
  DELETEA(vp_src); DELETEA(fp_src);
  return(1);
 }

#ifdef OGL20
 // vytvorenie shader objektu (kontajnera)
 vertex=glCreateShader(GL_VERTEX_SHADER);
 fragment=glCreateShader(GL_FRAGMENT_SHADER);
 // kod shaderov
 glShaderSource(vertex,1,(const char**) &vp_src,NULL);
 glShaderSource(fragment,1,(const char**) &fp_src,NULL);
 // kompilacia shaderov
 glCompileShader(vertex);
 glGetShaderiv(vertex,GL_INFO_LOG_LENGTH,&log_length);
 if (log_length<1000) {
  glGetShaderInfoLog(vertex,log_length,NULL,log);
  printf("vertex_shader_log: %s\n",log);
 }
 glCompileShader(fragment);
 glGetShaderiv(fragment,GL_INFO_LOG_LENGTH,&log_length);
 if (log_length<1000) {
  glGetShaderInfoLog(fragment,log_length,NULL,log);
  printf("fragment_shader_log: %s\n",log);
 }
 // vytvorenie program objektu (kontajnera)
 program=glCreateProgram();
 // pripojenie shaderov
 glAttachShader(program,vertex);
 glAttachShader(program,fragment);
 // zlozenie programu
 glLinkProgram(program);
 glGetProgramiv(program,GL_INFO_LOG_LENGTH,&log_length);
 if (log_length<1000) {
  glGetProgramInfoLog(program,log_length,NULL,log);
  printf("program_log: %s\n",log);
 }
#else
 vertex=glCreateShaderObjectARB(GL_VERTEX_SHADER_ARB);
 fragment=glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB);

 glShaderSourceARB(vertex,1,(const char**) &vp_src,NULL);
 glShaderSourceARB(fragment,1,(const char**) &fp_src,NULL);

 glCompileShaderARB(vertex);
 glGetObjectParameterivARB(vertex,GL_OBJECT_INFO_LOG_LENGTH_ARB,&log_length);
 if (log_length<1000) {
  glGetInfoLogARB(vertex,log_length,NULL,log);
  printf("vertex_shader_log: %s\n",log);
 }
 glCompileShaderARB(fragment);
 glGetObjectParameterivARB(fragment,GL_OBJECT_INFO_LOG_LENGTH_ARB,&log_length);
 if (log_length<1000) {
  glGetInfoLogARB(fragment,log_length,NULL,log);
  printf("fragment_shader_log: %s\n",log);
 }

 program=glCreateProgramObjectARB();

 glAttachObjectARB(program,vertex);
 glAttachObjectARB(program,fragment);

 glLinkProgramARB(program);
 glGetObjectParameterivARB(program,GL_OBJECT_INFO_LOG_LENGTH_ARB,&log_length);
 if (log_length<1000) {
  glGetInfoLogARB(program,log_length,NULL,log);
  printf("program_log: %s\n",log);
 }
#endif

 // nazov suborov s kodom vertex a fragment shadera
 printf("%s %s\n",VP,FP);

 // uvolnenie pamate vyhradenej pre kod shaderov
 DELETEA(vp_src); DELETEA(fp_src);

 return(0);
}

// zapnutie GLSL shadera ***************************************************
void CShader::on(void)
{
#ifdef OGL20
 // pouzitie programu
 glUseProgram(program);
#else
 glUseProgramObjectARB(program);
#endif
}

// vypnutie GLSL shadera ***************************************************
void CShader::off(void)
{
#ifdef OGL20
 // nepouzitie programu
 glUseProgram(0);
#else
 glUseProgramObjectARB(0);
#endif
}

// nastavenie atributov ****************************************************
void CShader::bindattriblocation(const GLuint I,const char *NAME)
{
#ifdef OGL20
 // pripojenie atributu
 // atribut NAME programu program sa spoji s generickym atributom I
 // program musi byt znovu linkovany
 glBindAttribLocation(program,I,NAME);
 glLinkProgram(program);
#else
 glBindAttribLocationARB(program,I,NAME);
 glLinkProgramARB(program);
#endif
}

// nastavenie uniform premennych *******************************************
void CShader::uniformI(const char *NAME,const int I)
{
#ifdef OGL20
 // umiestnenie premennej
 loc=glGetUniformLocation(program,NAME);
 // nastavenie premennej
 if (loc!=-1) glUniform1i(loc,I);
#else
 loc=glGetUniformLocationARB(program,NAME);
 if (loc!=-1) glUniform1iARB(loc,I);
#endif
}
void CShader::uniformF(const char *NAME,const float F0,const float F1,const float F2,const float F3)
{
#ifdef OGL20
 // umiestnenie premennej
 loc=glGetUniformLocation(program,NAME);
 // nastavenie premennej
 if (loc!=-1) glUniform4f(loc,F0,F1,F2,F3);
#else
 loc=glGetUniformLocationARB(program,NAME);
 if (loc!=-1) glUniform4fARB(loc,F0,F1,F2,F3);
#endif
}
void CShader::uniformmatrixFV(const char *NAME,const GLfloat *M)
{
#ifdef OGL20
 // umiestnenie matice
 loc=glGetUniformLocation(program,NAME);
 // nastavenie matice
 if (loc!=-1) glUniformMatrix4fv(loc,1,GL_FALSE,M); // umiestnenie, 1 matica, transponovat, hodnota
#else
 loc=glGetUniformLocationARB(program,NAME);
 if (loc!=-1) glUniformMatrix4fvARB(loc,1,GL_FALSE,M);
#endif
}
