#ifndef _SHADER_H_
#define _SHADER_H_

// praca so shadermi *******************************************************

// trieda premennych a funkcii pre pracu so shadermi
class CShader {
public:
 CShader();  // konstruktor
 ~CShader(); // destruktor

 // inicializacia pouzitia shaderov
 int init(void);

 // nacitanie kodu GLSL vertex & fragment shadera
 int load(const char *VP,const char *FP);
 void on(void);  // zapnutie GLSL shadera
 void off(void); // vypnutie GLSL shadera

 // nastavenie atributov
 void bindattriblocation(const GLuint I,const char *NAME);
 // nastavenie uniform premennych
 void uniformI(const char *NAME,const int I);
 void uniformF(const char *NAME,const float F0,const float F1,const float F2,const float F3);
 void uniformmatrixFV(const char *NAME,const GLfloat *M);
private:
#ifdef OGL20
 GLuint vertex,fragment,program;
#else
 GLhandleARB vertex,fragment,program;
#endif

 char log[1000]; // logovanie pripadnych chyb pri preklade programov
 GLint log_length;

 GLint loc; // umiestnenie premennej v ramci programu

 // nacitanie obsahu textoveho suboru
 char *TextFileRead(const char *FNAME);
};

/*
 odovzdavanie udajov:
 uniform - per primitive (outside glBegin - glEnd)
           hodnoty platia pre cely objekt, nie pre kazdy vrchol osobitne
 attrib - per vertex (inside glBegin - glEnd)
          pre kazdy vrchol osobitne, citat (nie menit) mozno iba vo vertex shaderi
 varying - interpolovane udaje prenasane z vertex do fragment shadera (po novom in, out)
 textury - udaje o farbach texelov mozu predstavovat odovzdavane udaje

 vertex shader - po vypocte per vertex atributov su tieto interpolovane a
                 odovzdane fragment shaderu
 fragment shader - vystupom operacii s interpolovanymi udajmi je farba fragmentu
*/

#endif
