// hlavickove subory *******************************************************
#include "../includes.h"
// vlastny .h subor
#include "text.h"

// konstruktor *************************************************************
CText::CText()
{
 // identifikator textury a displaylistov
 tex_id=0; list_id=0;

 // obsah textury (farby pixelov)
 data=NULL; d=NULL;
}

// destruktor **************************************************************
CText::~CText()
{
 if (tex_id) {
  glDeleteTextures(1,&tex_id); // zrusenie objektu textury
  printf("zrusenie textury id: %u\n",tex_id);
 }
 if (list_id) glDeleteLists(list_id,256); // zrusenie displaylistov
}

// inicializacia textu *****************************************************
int CText::init(const char *FONT_FILE)
{
 // SDL nacitanie obsahu suboru s texturou
 SDL_Surface *texImage=IMG_Load(FONT_FILE);
 if (texImage==NULL) {
  printf("Nepodarilo sa nacitat texturu: %s\n",FONT_FILE); return(1);
 }

 // sirka a vyska textury
 w=(GLuint) texImage->w; h=(GLuint) texImage->h;
 if (w==0 || h==0) { printf("Nespravna velkost textury!\n"); return(1); }

 // premenna data bude ukazovat na farbu pixelov textury
 data=(GLubyte *) texImage->pixels;

 // OpenGL vygenerovanie objektu textury
 glGenTextures(1,&tex_id);
 glBindTexture(GL_TEXTURE_2D,tex_id);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
 glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,w,h,0,GL_RGBA,GL_UNSIGNED_BYTE,data);

 // INFO: identifikator, sirka, vyska a nazov suboru textury
 printf("font textura: %u %u %u %s\n",tex_id,w,h,FONT_FILE);

 // rozmer jedneho znaku v texture (jedna pozicia)
 step=w/16; // 512/16=32 = rozmer jedneho znaku v texture
 step2=(GLfloat) step/2.0f;

 // vypocet pozicii jednotlivych znakov v ramci textury
 for (y=0,i=0;y<16;y++) {  // pre 16 pozicii v smere y
  for (x=0;x<16;x++,i++) { // pre 16 pozicii v smere x
   // najdenie lavej hranice, na ktorej zacina znak
   pos[i][0]=0;
   for (j=0;j<step;j++) { // kontrola vsetkych bodov v smere +x
    d=data+(x*step+y*w*step+j)*4;
    for (k=0;k<step;k++) { // kontrola vsetkych bodov v smere +y
     if (*(d+3)!=0) break; // ak je najdena alfa zlozka farby
     d+=w*4; // dalsi riadok
    }
    if (k!=step) break; // ak bola najdena alfa zlozka farby
    pos[i][0]++; // postupuje sa zlava - doprava, hlada sa lava hranica znaku
   }
   pos[i][1]=0;
   // ak sa na danej pozicii nenasiel znak, pokracuje sa dalsou poziciou
   if (pos[i][0]==step) continue;
   // najdenie pravej hranice, na ktorej konci znak
   for (j=step-1;j>=0;j--) { // kontrola vsetkych bodov v smere -x
    d=data+(x*step+y*w*step+j)*4;
    for (k=0;k<step;k++) { // kontrola vsetkych bodov v smere +y
     if (*(d+3)!=0) break; // ak je najdena alfa zlozka farby
     d+=w*4; // dalsi riadok
    }
    if (k!=step) break; // ak bola najdena alfa zlozka farby
    pos[i][1]++; // postupuje sa zprava - dolava, hlada sa prava hranica znaku
   }
   // vypocet sirky znaku
   pos[i][1]=step-pos[i][0]-pos[i][1];
  }
 }

 // OpenGL vygenerovanie 256-tich displaylistov
 list_id=glGenLists(256);

 // vytvorenie jednotlivych displaylistov
 for (y=0,i=0;y<16;y++) {  // pre 16 pozicii v smere y
  for (x=0;x<16;x++,i++) { // pre 16 pozicii v smere x
   // x suradnica textury
   s=(GLfloat) x/16.0f+(GLfloat) pos[i][0]/(GLfloat) w;
   // y suradnica textury
   t=(GLfloat) y/16.0f;
   // sirka znaku
   ds=(GLfloat) pos[i][1]/(GLfloat) w;
   // vyska znaku = cela vyska jednej pozicie
   dt=1.0f/16.0f;
   // ulozenie znaku do displaylistu list_id+i
   glNewList(list_id+i,GL_COMPILE);
    glBegin(GL_QUADS); // glOrtho() vymeni Y
     glTexCoord2f(s,t);       glVertex2i(0,0);
     glTexCoord2f(s,t+dt);    glVertex2i(0,step);
     glTexCoord2f(s+ds,t+dt); glVertex2i(pos[i][1],step);
     glTexCoord2f(s+ds,t);    glVertex2i(pos[i][1],0);
    glEnd();
    // nastavenie polohy nasledujuceho znaku
    glTranslatef((GLfloat) pos[i][1],0.0f,0.0f);
   glEndList();
  }
 }

 // uvolnenie pouzitej pamate
 if (texImage!=NULL) SDL_FreeSurface(texImage);
 texImage=NULL;

 return(0);
}

// vypis textu *************************************************************
void CText::draw(GLfloat X,GLfloat Y,const char *STRING)
{
 glPushMatrix(); // ulozenie modelview matice
 // velkost textu
 glScalef(sx,sy,1.0f);
 // vykreslenie textu na poziciu x, y
 glTranslatef(X,Y,0.0f);
 // vykreslenie displaylistov prisluchajucich jednotlivym znakom
 for (i=1;*STRING!='\0';STRING++) {
  if (*STRING==' ') {         // space
   glTranslatef(step2,0.0f,0.0f);
  } else if (*STRING=='\n') { // new line
          glLoadIdentity();
          glScalef(sx,sy,1.0f);
          glTranslatef(X,Y+(GLfloat) (i*step),0.0f); i++;
         } else {             // znak
            glCallList(list_id+*STRING);
           }
 }
 glPopMatrix(); // obnova modelview matice
}

// vypis formatovaneho textu ***********************************************
void CText::drawf(GLfloat X,GLfloat Y,const char *FORMAT,...)
{
 // presun argumentov do pomocneho zasobnika na zaklade zvoleneho formatu vypis textu
 va_start(args,FORMAT);
 vsprintf(buf,FORMAT,args);
 va_end(args);
 // vypis textu
 draw(X,Y,buf);
}
