#ifndef _TEXT_H_
#define _TEXT_H_

// trieda premennych a funkcii pre pracu s OpenGL textom
class CText {
public:
 CText();  // konstruktor
 ~CText(); // destruktor

 GLuint tex_id; // identifikator textury

 // inicializacia textu
 int init(const char *FONT_FILE);
 // velkost textu
 void scale(GLfloat SX,GLfloat SY) { sx=SX; sy=SY; }
 // vypis textu
 void draw(GLfloat X,GLfloat Y,const char *STRING);
 // vypis formatovaneho textu
 void drawf(GLfloat X,GLfloat Y,const char *FORMAT,...);
private:
 GLuint list_id; // identifikator displaylistov

 GLuint w,h;       // sirka a vyska textury
 GLubyte *data,*d; // obsah textury (farby pixelov) - iba ukazovatele
                   // nie je potrebne uvolnovat pamat

 GLuint step; // rozmer jedneho znaku v texture
 GLfloat step2; // 2x rozmer jedneho znaku v texture

 GLuint x,y;   // pomocne premenne
 GLuint i,j,k; // pomocne premenne

 GLuint pos[256][2]; // pomocne pole pre ulozenie zaciatku a sirky znakov
                     // [0] - zaciatok znaku v ramci pozicie,
                     // [1] - sirka znaku
 GLfloat s,t,ds,dt;  // pomocne premenne

 GLfloat sx,sy,sz; // skalovanie textu

 va_list args;   // formatovanie textu
 char buf[1024]; // pomocny zasobnik pre znaky
};

#endif
