// hlavickove subory *******************************************************
#include "../includes.h"
// vlastny .h subor
#include "texture.h"

// konstruktor *************************************************************
CTexture::CTexture()
{
 loopi(MAX_TEX_NUM) tex_id[i]=0;

 // pocet nahratych textur
 tex_count=0;
 
 // SDL nacitanie suboru s obrazkom textury
 img=NULL;
 // pomocna pamat
 data=NULL;
}

// destruktor **************************************************************
CTexture::~CTexture()
{
 // zrusenie objektov textur
 loopi(tex_count) {
  if (tex_id[i]!=0) freeTexture(i);
  else tex_count++; // ak objekt textury neexistuje, cyklus pokracuje
                    // na dalsom indexe az do zrusenia zadaneho poctu objektov
 }
 tex_count=0;
}

// uprava farieb bodov textury na zaklade typu suboru **********************
int CTexture::correctData(SDL_Surface *S)
{
 GLuint w=(GLuint) S->w,h=(GLuint) S->h;
 GLubyte *pixels=(GLubyte *) S->pixels;
 GLubyte palIndex;

 if (S->format==NULL) { printf("Chyba formatu obrazku!\n"); return(1); }

 // obrazok bez palety
 if (S->format->palette==NULL) {
  bpp=S->format->BytesPerPixel; // pocet bytov na texel
  // INFO: bpp
  //printf("bpp: %u\n",bpp);

  // vyhradenie pamate pre farby bodov textury
  data=new GLubyte[w*h*bpp];
  if (data==NULL) { printf("Nemozno vyhradit pamat!\n"); return(1); }

  unsigned int rr,gg,bb,aa;
  // kopirovanie R G B (A) zloziek farby
  switch (bpp) {
   case 3: if (S->format->Bshift!=0) { rr=0; bb=2; }
           else { rr=2; bb=0; }
           loopj(h) {
            for (unsigned int i=0;i<w*3;i+=3) {
             data[i+j*w*bpp+0]=pixels[i+j*w*bpp+rr]; // R - R/B
             data[i+j*w*bpp+1]=pixels[i+j*w*bpp+1];  // G - G
             data[i+j*w*bpp+2]=pixels[i+j*w*bpp+bb]; // B - B/R
            }
           }
           break;
   case 4: if (S->format->Ashift!=0) { rr=0; gg=1; bb=2; aa=3; }
           else { rr=3; gg=2; bb=1; aa=0; }
           loopj(h) {
            for (unsigned int i=0;i<w*4;i+=4) {
             data[i+j*w*bpp+0]=pixels[i+j*w*bpp+rr]; // R - R/A
             data[i+j*w*bpp+1]=pixels[i+j*w*bpp+gg]; // G - G/B
             data[i+j*w*bpp+2]=pixels[i+j*w*bpp+bb]; // B - B/G
             data[i+j*w*bpp+3]=pixels[i+j*w*bpp+aa]; // A - A/R
            }
           }
           break;
   default: printf("Nemozno skopirovat farby!\n"); DELETEA(data); return(1);
  }
 }
 // obrazok s paletou
 else {
  bpp=3; // predpoklad 3 byty na texel
  // INFO: bpp
  //printf("bpp: %u\n",bpp);

  // kontrola palety
  if (S->format->palette->colors==NULL) { printf("Chyba v palete obrazku!\n"); return(1); }

  // vyhradenie pamate pre farby bodov textury
  data=new GLubyte[w*h*bpp];
  if (data==NULL) { printf("Nemozno vyhradit pamat!\n"); return(1); }

  unsigned int k;
  // kopirovanie R G B zloziek farby
  loopj(h) {
   k=0;
   loopi(w) {
    palIndex=pixels[i+j*w]; // index do palety
    data[k+j*w*bpp+0]=S->format->palette->colors[palIndex].r; // R - R
    data[k+j*w*bpp+1]=S->format->palette->colors[palIndex].g; // G - G
    data[k+j*w*bpp+2]=S->format->palette->colors[palIndex].b; // B - B
    k+=3;
   }
  }
 }

 // vyber formatu udajov ulozenych v texture
 switch (bpp) {
  case 1: glFormat=GL_ALPHA; break;
  case 3: glFormat=GL_RGB; break;
  case 4: glFormat=GL_RGBA; break;
  default: printf("Nemozno vybrat format udajov ulozenych v texture!\n");
           DELETEA(data); return(1);
 }

 // vyber interneho formatu udajov ulozenych v texture
 switch (glFormat) {
  case GL_ALPHA:
   switch (bpp) {
    case 1: intFormat=GL_ALPHA; break;
    default: printf("Nemozno vybrat interny format udajov ulozenych v texture!\n");
             DELETEA(data); return(1);
   }
  break;
  case GL_RGB:
   switch (bpp) {
    case 3: intFormat=GL_RGB; break;
    default: printf("Nemozno vybrat interny format udajov ulozenych v texture!\n");
             DELETEA(data); return(1);
   }
  break;
  case GL_RGBA:
   switch (bpp) {
    case 4: intFormat=GL_RGBA4; break;
    default: printf("Nemozno vybrat interny format udajov ulozenych v texture!\n");
             DELETEA(data); return(1);
   }
  break;
 }

 return(0);
}

// nastavenie parametrov a vytvorenie 2D textury ***************************
void CTexture::genTexture(GLuint W,GLuint H,GLubyte *DATA,GLuint MODE)
{
 // nastavenie filteringu
 if (MODE & T_LINEAR) { // LINEAR
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  if (MODE & T_MIPMAP) {
   glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
  } else {
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    }
 } else {             // NEAREST
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
    if (MODE & T_MIPMAP) {
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST_MIPMAP_NEAREST);
    } else {
       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
      }
   }
 // nastavenie opakovania sa textury
 if (MODE & T_CLAMP) {
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
 } else if (MODE & T_CLAMP_TO_EDGE) {
         glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP_TO_EDGE);
         glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP_TO_EDGE);
        } else {
           glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
           glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
          }
 // vytvorenie objektu textury
 if (MODE & T_MIPMAP) { // MIPMAP
  gluBuild2DMipmaps(GL_TEXTURE_2D,intFormat,W,H,glFormat,GL_UNSIGNED_BYTE,DATA);
 } else {             // standardna 2D textura
    glTexImage2D(GL_TEXTURE_2D,0,intFormat,W,H,0,glFormat,GL_UNSIGNED_BYTE,DATA);
   }
}

// nahratie 2D textury *****************************************************
int CTexture::load2D(GLuint ID,const char *F,GLuint MODE)
{
 if ((tex_count+1)>=MAX_TEX_NUM) {
  printf("Prekroceny maximalny pocet textur!\n"); return(1);
 }

 // nacitanie suboru s obrazkom textury
 img=NULL; img=IMG_Load(F); if (img==NULL) return(1);

 // uprava farieb bodov textury na zaklade typu suboru
 if (correctData(img)) {
  printf("Nemozno upravit farby bodov textury!\n");
  // uvolnenie pouzitej pamate
  if (img) SDL_FreeSurface(img); img=NULL;
  return(1);
 }

 // vygenerovanie textury
 glGenTextures(1,&tex_id[ID]);
 tex_count++; // zvysenie poctu textur
 // pripojenie textury
 glBindTexture(GL_TEXTURE_2D,tex_id[ID]);
 // nastavenie parametrov a vytvorenie 2D textury
 genTexture((GLuint) img->w,(GLuint) img->h,data,MODE);

 // uvolnenie vyhradenej pamate (vyhradenej v correctData())
 DELETEA(data);

 // uvolnenie pouzitej pamate
 if (img) SDL_FreeSurface(img); img=NULL;

 // INFO: identifikator a nazov suboru textury
 printf("2D textura: %u %s\n",tex_id[ID],F);

 return(0);
}

// zrusenie textury ********************************************************
void CTexture::freeTexture(GLuint ID)
{
 printf("zrusenie textury id: %u\n",tex_id[ID]);
 glDeleteTextures(1,&tex_id[ID]);
}
