#ifndef _TEXTURE_H_
#define _TEXTURE_H_

// praca s texturami *******************************************************

// maximalny pocet textur
#define MAX_TEX_NUM 256

// volitelne parametre textury
enum {
 T_DEFAULT=1<<0,
 T_CLAMP=1<<1,
 T_CLAMP_TO_EDGE=1<<2,
 T_NEAREST=1<<3,
 T_LINEAR=1<<4,
 T_MIPMAP=1<<5
};

// trieda premennych a funkcii pre pracu s OpenGL texturami
class CTexture {
public:
 CTexture();  // konstruktor
 ~CTexture(); // destruktor

 GLuint tex_count; // pocet nahratych textur

 GLuint tex_id[MAX_TEX_NUM]; // identifikatory nahratych textur

 int load2D(GLuint ID,const char *F,GLuint MODE); // nahratie 2D textury

 void freeTexture(GLuint ID); // zrusenie textury
private:
 // SDL nacitanie suboru s obrazkom textury
 SDL_Surface *img;

 // pomocna pamat
 GLubyte *data;

 // pocet bytov na texel (bod textury)
 GLuint bpp;
 // format a interny format udajov ulozenych v texture (na zaklade bpp)
 GLuint glFormat,intFormat;

 // uprava farieb bodov textury na zaklade typu suboru
 int correctData(SDL_Surface *S);
 // nastavenie parametrov a vytvorenie 2D textury
 void genTexture(GLuint W,GLuint H,GLubyte *DATA,GLuint MODE);
};

#endif
