// *************************************************************************
// * autor:   Marek Sopko                                                  *
// * kontakt: ... Banovce nad Bebravou, Slovenska republika                *
// *          http:   www.softengine.sk                                    *
// *          e-mail: mareksopko.ms@gmail.com                              *
// *          mobil:  +421 907 952 453                                     *
// *                                                                       *
// * popis aplikacie: glsl v1.2                                            *
// *************************************************************************

// obsahom glsl.cpp su nasledujuce funkcie:
// - inicializacia SDL
// - zmena velkosti kresliacej plochy po zmene velkosti okna
// - obsluha klavesnice
// - obsluha mysi
// - uvolnenie alokovanych zdrojov a obnovenie povodnych nastaveni obrazovky
// - hlavna vykonavacia funkcia aplikacie

// hlavickove subory *******************************************************
#include "includes.h"
// vlastny .h subor
//#include "glsl.h"

// hlavny interface aplikacie
#include "interface.h"

// *************************************************************************
// * deklaracie a definicie premennych a konstant                          *
// *************************************************************************
// sirka, vyska a farebna hlbka (pocet bitov na 1 pixel) kresliacej plochy
// pozn.: v X11, SDL_SetVideoMode nemeni rozlisenie obrazovky,
//        vo Win32, ChangeDisplaySettings moze zmenit bpp
// scr_bpp=0 znamena, ze bude pouzita aktualna farebna hlbka obrazovky
int scr_w=800,scr_w2=scr_w/2;
int scr_h=600,scr_h2=scr_h/2;
int scr_bpp=0;

// znacky pre SDL_SetVideoMode
Uint32 videoFlags=0;
// celoobrazovkove zobrazenie
bool fullscr=false;
// informacie o SDL video subsysteme
const SDL_VideoInfo *videoInfo=NULL;
// vertikalna synchronizacia
int vsync=-1;
// celoobrazovkove vyhladzovanie
int fsaa=-1;
// SDL kresliaca plocha
SDL_Surface *surface=NULL;
// nazov okna a ikony
char APP_title[64]="glsl v1.2 (OpenGL API)";
// opakovanie stlacenia klaves
bool keyrepeat=false;

// hlavny interface aplikacie - implementuje funkcie OpenGL kniznice
CInterface *interface=NULL;

// ukoncenie hlavneho cyklu
int isDone=0;
// obsluha udalosti
SDL_Event event;
// mys je/nie je aktivna
int grabmouse=0;
// pocas startu aplikacie sa nebude brat do uvahy poloha mysi
int ignoremouse=1;
// SDL okno je/nie je aktivne
int isActive=1;
// SDL last event type, last event button
int lasttype=0,lastbutton=0;
// SDL stav klaves
Uint8 *keystate=NULL;
// stlacenie laveho a praveho tlacidla mysi
bool lbutton=false,rbutton=false,onbutton=false;
// poloha mysi v pripade ak sa nachadza na tlacidle
int butx=scr_w2,buty=scr_h2;

// *************************************************************************
// * definicie funkcii aplikacie                                           *
// *************************************************************************
// inicializacia SDL *******************************************************
int SDL_initialize(void)
{
 printf("SDL init...\n");

 // inicializacia SDL
 if (SDL_Init(SDL_INIT_TIMER | SDL_INIT_VIDEO | SDL_INIT_AUDIO)<0) {
  printf("Chyba inicializacie SDL: %s\n",SDL_GetError());
  return(1);
 }

 // znacky pre SDL_SetVideoMode
 videoFlags=SDL_OPENGL;                   // zapnutie OpenGL v SDL
 #if !defined(WIN32)
  videoFlags|=SDL_RESIZABLE;              // povolenie zmeny velkosti SDL okna
 #endif
 if (fullscr) videoFlags|=SDL_FULLSCREEN; // celoobrazovkove zobrazenie
 //videoFlags|=SDL_GL_DOUBLEBUFFER;         // dvojity zasobnik pre prekreslovanie
 //videoFlags|=SDL_HWPALETTE;               // ulozenie palety do HW
 // ziskanie informacii o SDL video subsysteme
 videoInfo=SDL_GetVideoInfo();
 if (!videoInfo) {
  printf("Chyba ziskania informacii o SDL video subsysteme: %s\n",SDL_GetError());
  return(1);
 }
 // kontrola, ci mozno SDL kresliacu plochu umiestnit do HW
 //if (videoInfo->hw_available) videoFlags|=SDL_HWSURFACE;
 //else videoFlags|=SDL_SWSURFACE;
 // kontrola, ci mozno pracovat s HW blit
 // blitting - kopia casti zdrojovej textury do cielovej textury
 //if (videoInfo->blit_hw) videoFlags|=SDL_HWACCEL;

 // nastavenie atributov SDL kresliacej plochy
 // 8b pre cervenu, zelenu a modru farbu
 // 8b pre alfa kanal
 // 1 - dvojity zasobnik pre prekreslovanie
 // 16b zasobnik hlbky
 // 1b stencil zasobnik
 //SDL_GL_SetAttribute(SDL_GL_RED_SIZE,    8);
 //SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE,  8);
 //SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE,   8);
 //SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE,  8);
 SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER,1);
 // pozn.: SDL_GL_DOUBLEBUFFER sa pouziva v SDL_GL_SetAttribute,
 // v SDL_SetVideoMode ovplyvni iba 2D prekreslovanie
 SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE,  16);
 SDL_GL_SetAttribute(SDL_GL_STENCIL_SIZE,1);
 // vertikalna synchronizacia
 #if SDL_VERSION_ATLEAST(1,2,11)
  if (vsync>=0) SDL_GL_SetAttribute(SDL_GL_SWAP_CONTROL,vsync);
 #endif
 // celoobrazovkove vyhladzovanie
 if (fsaa>0) {
  SDL_GL_SetAttribute(SDL_GL_MULTISAMPLEBUFFERS,1);
  SDL_GL_SetAttribute(SDL_GL_MULTISAMPLESAMPLES,fsaa);
  printf("FSAA ON, samples: %i\n",fsaa);
 }

 // nastavenie SDL kresliacej plochy
 surface=SDL_SetVideoMode(scr_w,scr_h,scr_bpp,videoFlags);
 if (!surface) {
  printf("Chyba nastavenia SDL kresliacej plochy: %s\n",SDL_GetError());
  return(1);
 }

 // INFO: sirka a vyska SDL kresliacej plochy
 printf("sirka: %i, vyska: %i\n",surface->w,surface->h);

 // sirka a vyska kresliacej plochy
 scr_w=surface->w; scr_w2=scr_w/2;
 scr_h=surface->h; scr_h2=scr_h/2;

 // prevzatie vstupu
 #ifdef WIN32
  SDL_WM_GrabInput(SDL_GRAB_ON);
 #else
  SDL_WM_GrabInput(fullscr ? SDL_GRAB_ON : SDL_GRAB_OFF);
 #endif

 // nastavenie nazvu okna a ikony
 SDL_WM_SetCaption(APP_title,NULL);
 // opakovanie stlacenia klaves
 SDL_EnableKeyRepeat(keyrepeat ? SDL_DEFAULT_REPEAT_DELAY : 0,
                     SDL_DEFAULT_REPEAT_INTERVAL);

 return(0);
}

// zmena velkosti kresliacej plochy po zmene velkosti okna *****************
int WND_resize(int W,int H)
{
 // zmena velkosti SDL kresliacej plochy
 SDL_Surface *tmp_surface=SDL_SetVideoMode(W,H,scr_bpp,surface->flags);
 if (!tmp_surface) {
  printf("Chyba nastavenia SDL kresliacej plochy po zmene velkosti okna: %s\n",
         SDL_GetError());
  return(1);
 }
 surface=tmp_surface;

 // sirka a vyska kresliacej plochy
 scr_w=surface->w; scr_w2=scr_w/2;
 scr_h=surface->h; scr_h2=scr_h/2;

 // inicializacia parametrov Avatara po zmene velkosti kresliacej plochy
 if (interface!=NULL) interface->avatar.init();

 return(0);
}

// obsluha klavesnice ******************************************************
void APP_keyboard(void)
{
 keystate=SDL_GetKeyState(NULL); // nacitanie stavu klaves

 isDone=(int) keystate[SDLK_ESCAPE];                          // ESC

 if (lbutton || rbutton) {
  // pohyb Avatara
  interface->avatar.goForward=(GLfloat) keystate[SDLK_w];     // dopredu
  interface->avatar.goBack=   (GLfloat) keystate[SDLK_s];     // dozadu
  interface->avatar.goLeft=   (GLfloat) keystate[SDLK_a];     // dolava
  interface->avatar.goRight=  (GLfloat) keystate[SDLK_d];     // doprava
  interface->avatar.goUp=     (GLfloat) keystate[SDLK_r];     // hore
  interface->avatar.goDown=   (GLfloat) keystate[SDLK_f];     // dole

  // nastavenie prirastkov pre zmenu polohy Avatara
  interface->avatar.setmovxyz();
 }
}

// obsluha mysi ************************************************************
void APP_mouse(int DX,int DY)
{
 // ak je mys na tlacidle
 if (onbutton) interface->button_update((float) DX);
 else {
  // nastavenie prirastkov pre zmenu natocenia Avatara
  interface->avatar.setrotab((GLfloat) DX,(GLfloat) DY);
 }
}

// uvolnenie alokovanych zdrojov a obnovenie povodnych nastaveni obrazovky *
void APP_quit(int RETURNCODE)
{
 // zrusenie objektu (instancia) triedy CInterface
 DELETEP(interface);
 // zrusenie SDL okna
 SDL_Quit();
 // ukoncenie aplikacie
 exit(RETURNCODE);
}

// hlavna vykonavacia funkcia aplikacie ************************************
int main(int argc,char **argv)
{
 printf("----------------------------------------------------------\n");

 // inicializacia SDL
 SDL_initialize();

 printf("----------------------------------------------------------\n");

 // vytvorenie objektu (instancie) triedy CInterface
 interface=new CInterface();
 if (interface==NULL) {
  printf("Chyba vytvorenia objektu (instancie) triedy CInterface!\n");
  APP_quit(1);
 }

 // inicializacia OpenGL
 if (interface->OGL_initialize()) APP_quit(1);

 printf("----------------------------------------------------------\n");

 // nastartovanie casovaca
 interface->resettimer();
 grabmouse=1;

 // hlavny programovy cyklus
 while (!isDone) {
  // ukladanie a spracovavanie udalosti
  lasttype=0; lastbutton=0;
  while (SDL_PollEvent(&event)) {
   switch (event.type) {
    case SDL_ACTIVEEVENT:      // kreslenie iba ak je okno aktivne
     if (event.active.state & SDL_APPINPUTFOCUS) grabmouse=event.active.gain;
     if (event.active.gain) {  // ak dojde k aktivacii okna
      interface->resettimer(); // restartuje sa casovac
      grabmouse=1;
      isActive=1;
     } else {                  // okno nie je aktivne
        grabmouse=0;
        isActive=0;
       }
    break;
    #if !defined(WIN32)
    case SDL_VIDEORESIZE:      // zmena velkosti kresliacej plochy
     WND_resize(event.resize.w,event.resize.h);
    break;
    #endif
    case SDL_QUIT:             // zrusenie SDL okna
     isDone=1;
    break;
    case SDL_KEYDOWN:          // obsluha klavesnice
    case SDL_KEYUP:
     APP_keyboard();
    break;
    case SDL_MOUSEMOTION:      // obsluha mysi
     if (ignoremouse) { ignoremouse--; break; }
     if (lbutton || rbutton) {
      if (!onbutton) {
       onbutton=interface->on_button((float) event.motion.x,(float) event.motion.y);
       if (onbutton) { butx=event.motion.x; buty=event.motion.y; }
      }
      #ifndef WIN32
      if (!(surface->flags & SDL_FULLSCREEN) && grabmouse) {
       if (event.motion.x==scr_w2 && event.motion.y==scr_h2) break;
       SDL_WarpMouse(scr_w2,scr_h2);
      }
      if ((surface->flags & SDL_FULLSCREEN) || grabmouse)
      #endif
       APP_mouse(event.motion.xrel,event.motion.yrel);
     }
    break;
    case SDL_MOUSEBUTTONDOWN:
     if (lasttype==event.type && lastbutton==event.button.button) break;
     lasttype=event.type; lastbutton=event.button.button;
     // schovanie kurzoru mysi
     SDL_ShowCursor(SDL_DISABLE);
     // stlacenie laveho a praveho tlacidla mysi
     lbutton=(bool) SDL_GetMouseState(NULL,NULL)&SDL_BUTTON(SDL_BUTTON_LEFT);
     rbutton=(bool) SDL_GetMouseState(NULL,NULL)&SDL_BUTTON(SDL_BUTTON_RIGHT);
    break;
    case SDL_MOUSEBUTTONUP:
     if (lasttype==event.type && lastbutton==event.button.button) break;
     lasttype=event.type; lastbutton=event.button.button;
     // zobrazenie kurzoru mysi
     SDL_ShowCursor(SDL_ENABLE);
     lbutton=false; rbutton=false;
     if (onbutton) SDL_WarpMouse(butx,buty);
     onbutton=false;
     // zastavenie pohybu Avatara
     interface->avatar.stop();
    break;
    default: break;
   }
  }
  // aktualizacia a vykreslenie sceny
  if (isActive) {
   // aktualizacia parametrov Avatara
   interface->avatar.update();
   // casovo zavisla uprava objektov, resp. sceny
   interface->OGL_idle();
   // vykreslenie OpenGL sceny
   interface->OGL_draw();
   // vymena zobrazovacich zasobnikov => zobrazenie sceny
   SDL_GL_SwapBuffers();
  }
  // aktualizacia casovaca
  interface->updatetimer();
 }

 // ukoncenie aplikacie
 APP_quit(0);
}
