#ifndef _INCLUDES_H_
#define _INCLUDES_H_

// standardne hlavickove subory pre vsetky moduly **************************

// systemove kniznice ******************************************************

// definicie pre Windows a Linux *******************************************
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#define PATHDIV '\\'
#else
#define LINUX
#define PATHDIV '/'
#endif

// definicie pre aplikaciu *************************************************

// podmieneny preklad OpenGL 2.0 / ARB
#define OGL20

// maximalny pocet fps
#define MAXFPS 200

// SDL kniznica ************************************************************
// /usr/lib/libSDL.so
// /usr/lib/libSDL_image.so
#include <SDL.h>
#include <SDL_image.h>

// GLEW, OpenGL, GLU a GLEXT kniznice **************************************
// The OpenGL Extension Wrangler Library http://glew.sourceforge.net
// /usr/lib/libGLEW.so
#include <GL/glew.h>
// vyber konkretnych kniznic je zavisly na pouzitom grafickom hardveri
// a implementacii OpenGL (napr. pomocou Mesa kniznice)
// /usr/lib/libGL.so, alebo v zavislosti na GPU
// napr. /usr/lib/nvidia/libGL.so
// /usr/lib/libGLU.so
// v pripade pouzitia GLEXT kniznice sa pouzije subor suvisiaci s GPU
// napr. /usr/lib/xorg/modules/extensions/nvidia/libglx.so
#define GL_GLEXT_PROTOTYPES
// informacia pre gl.h aby nepripojil obsah suboru glext.h
#define __glext_h__
// pripoji obsah suborov gl.h a glu.h, nepripoji obsah suboru SDL_opengl.h
#define NO_SDL_GLEXT
#include <SDL_opengl.h>
#undef __glext_h__
#include <GL/glext.h>

// rozne pomocne nastroje **************************************************
#include "common/tools.h"
// rozne geometricke a matematicke funkcie *********************************
#include "common/math3d.h"
// praca s texturami *******************************************************
#include "common/texture.h"
// praca s textom **********************************************************
#include "common/text.h"
// praca so shadermi *******************************************************
#include "common/shader.h"

// globalne premenne *******************************************************

// definovane v glsl.cpp:
extern int scr_w,scr_w2;
extern int scr_h,scr_h2;

// definovane v interface.cpp:
extern GLfloat dTime;
extern Cmath3d mm;
extern CTexture texture;
extern GLuint tid[MAX_TEX_NUM];
extern CText text;

// definovane v shader.cpp:
extern CShader base_shader;
extern CShader light_shader;
extern CShader brick_shader;

#endif
