// hlavickove subory *******************************************************
#include "includes.h"
// vlastny .h subor
#include "interface.h"

// uplynuty cas medzi aktualnym a povodnym casovym okamihom (s)
GLfloat dTime;

// pre pracu s matematikou
Cmath3d mm;

// instancia triedy CTexture - praca s texturami
CTexture texture;
// ciselne oznacenia textur - nie su totozne s identifikatormi nahratych textur v CTexture!
// vyhradene oznacenia:
// 0 - prazdna (empty) textura
// 1 - standardna (default) textura
// 2 - zameriavaci kriz
// <10;(MAX_TEX_NUM-1)> - ostatne textury
GLuint tid[MAX_TEX_NUM];

// instancia triedy CText - praca s textom
CText text;

// pocet segmentov gule, valca, ihlana
int segs=18;
// pocet udajov / 3 = pocet trojuholnikov
/*
int data_num=108+                          // kocka
             (360/segs*18)*(180/segs)+     // gula
             (360/segs*18)+(360/segs*9)*2+ // valec
             (360/segs*9)+(360/segs*9)+    // ihlan
             18+18;                        // plochy
*/
// vrcholy, farba, TBN, texturovacie suradnice
// 108 + 3600 + 720 + 360 + 18 + 18 = 4824
float v_a[4824],c_a[4824],tan_a[4824],bin_a[4824],nor_a[4824],t_a[4824];

// konstruktor *************************************************************
CInterface::CInterface()
{

}

// destruktor **************************************************************
CInterface::~CInterface()
{
 // Vertex Array Object
 glDeleteVertexArrays(1,&vao);
}

// inicializacia OpenGL - nastavenie parametrov OpenGL sceny ***************
int CInterface::OGL_initialize(void)
{
 printf("OpenGL init...\n");

 GLenum err=glewInit();
 if (err!=GLEW_OK) { printf("GLEW error: %s\n",glewGetErrorString(err)); return(1); }
 printf("using GLEW %s\n",glewGetString(GLEW_VERSION));

 // STAVOVY STROJ STAVOVY STROJ STAVOVY STROJ STAVOVY STROJ STAVOVY STROJ --

 // farba, ktorou sa bude resetovat zasobnik farieb
 glClearColor(0.2f,0.2f,0.2f,1.0f);
 // zasobnik hlbky bude vymazavany nastavenim na 1.0f
 glClearDepth(1.0f);
 // pomocny zasobnik bude vymazavany nastavenim na 0.0f
 glClearStencil(0.0f);

 glDepthFunc(GL_LESS);    // typ porovnavacej funkcie pre urcenie Z-vzdialenosti
 glEnable(GL_DEPTH_TEST); // testovanie Z-vzdialenosti

 glDisable(GL_CULL_FACE); // poradie, v ktorom budu definovane vrcholy objektov
 glFrontFace(GL_CCW);     // reprezentovat privratene, resp. odvratene plochy,
 glCullFace(GL_BACK);     // CCW - proti smeru hod. ruciciek, CW - v smere hod. ruciciek
 glEnable(GL_CULL_FACE);  // odvratene plochy sa nebudu spracovavat

 // osvetlenie
 lsrcparam.ambient.set(0.0f,0.0f,0.0f,1.0f);
 lsrcparam.diffuse.set(0.5f,0.5f,0.5f,1.0f);
 lsrcparam.specular.set(0.3f,0.3f,0.3f,1.0f);
 lsrcparam.position.set(5.0f,5.0f,0.0f,1.0f);
 lsrcparam.spotDirection.set(0.0f,0.0f,-1.0f);
 lsrcparam.spotExponent=0.0f;
 lsrcparam.spotCutoff=180.0f;
 lsrcparam.spotCosCutoff=-1.0f;
 lsrcparam.constantAttenuation=1.0f;
 lsrcparam.linearAttenuation=0.0f;
 lsrcparam.quadraticAttenuation=0.0f;

 lmodelparam.ambient.set(0.2f,0.2f,0.2f,1.0f);

 mparam.ambient.set(0.1f,0.1f,0.1f,1.0f);
 mparam.diffuse.set(0.2f,0.2f,0.2f,1.0f);
 mparam.specular.set(1.0f,1.0f,1.0f,1.0f);
 mparam.emission.set(0.0f,0.0f,0.0f,1.0f);
 mparam.shininess=128.0f;

 // aktualizacia parametrov osvetlenia
 update_lighting_params();

 // texturovanie je standardne zapnute
 glEnable(GL_TEXTURE_2D);

 // INICIALIZACIA SCENY INICIALIZACIA SCENY INICIALIZACIA SCENY ------------

 // nastavenie ciselnych oznaceni textur
 // vyhradene oznacenia:
 // 0 - prazdna (empty) textura
 // 1 - standardna (default) textura
 // 2 - zameriavaci kriz
 // <10;(MAX_TEX_NUM-1)> - ostatne textury
 loopi(MAX_TEX_NUM) tid[i]=i;

 // inicializacia Avatara
 avatar.init();

 // inicializacia textu - nahratie textury s fontom
 if (text.init("data/font/font.png")) {
  printf("Chyba inicializacie textu!\n"); return(1);
 }

 // nahratie prazdnej (empty) textury
 if (texture.load2D(tid[0],"data/textures/default/empty.png",T_LINEAR | T_MIPMAP)) {
  printf("Chyba nahratia prazdnej textury!\n"); return(1);
 }
 // nahratie standardnej (default) textury
 if (texture.load2D(tid[1],"data/textures/default/default.png",T_LINEAR | T_MIPMAP)) {
  printf("Chyba nahratia standardnej textury!\n"); return(1);
 }
 // nahratie textury zameriavacieho kriza
 if (texture.load2D(tid[2],"data/gfx/crosshair1.png",T_LINEAR | T_CLAMP)) {
  printf("Chyba nahratia textury zameriavacieho kriza!\n"); return(1);
 }
 // nahratie textury reprezentujucej svetelny zdroj
 if (texture.load2D(tid[10],"data/gfx/light_bulb.png",T_LINEAR | T_CLAMP)) {
  printf("Chyba nahratia textury svetelneho zdroja!\n"); return(1);
 }

 // velkost zameriavacieho kriza
 crosshairSize=50.0f;

 // tlacidla menu
 but[0].init(vec3(10.0f,90.0f,0.0f),30.0f,15.0f); but[1].init(vec3(45.0f,90.0f,0.0f),30.0f,15.0f);
 but[2].init(vec3(80.0f,90.0f,0.0f),30.0f,15.0f); but[3].init(vec3(115.0f,90.0f,0.0f),30.0f,15.0f);

 but[4].init(vec3(10.0f,120.0f,0.0f),30.0f,15.0f); but[5].init(vec3(45.0f,120.0f,0.0f),30.0f,15.0f);
 but[6].init(vec3(80.0f,120.0f,0.0f),30.0f,15.0f); but[7].init(vec3(115.0f,120.0f,0.0f),30.0f,15.0f);

 but[8].init(vec3(10.0f,150.0f,0.0f),30.0f,15.0f); but[9].init(vec3(45.0f,150.0f,0.0f),30.0f,15.0f);
 but[10].init(vec3(80.0f,150.0f,0.0f),30.0f,15.0f); but[11].init(vec3(115.0f,150.0f,0.0f),30.0f,15.0f);

 but[12].init(vec3(10.0f,180.0f,0.0f),30.0f,15.0f); but[13].init(vec3(45.0f,180.0f,0.0f),30.0f,15.0f);
 but[14].init(vec3(80.0f,180.0f,0.0f),30.0f,15.0f); but[15].init(vec3(115.0f,180.0f,0.0f),30.0f,15.0f);

 but[16].init(vec3(10.0f,210.0f,0.0f),30.0f,15.0f);
 but[17].init(vec3(10.0f,240.0f,0.0f),30.0f,15.0f);
 but[18].init(vec3(10.0f,270.0f,0.0f),30.0f,15.0f);

 but[19].init(vec3(10.0f,330.0f,0.0f),30.0f,15.0f); but[20].init(vec3(45.0f,330.0f,0.0f),30.0f,15.0f);
 but[21].init(vec3(80.0f,330.0f,0.0f),30.0f,15.0f); but[22].init(vec3(115.0f,330.0f,0.0f),30.0f,15.0f);

 but[23].init(vec3(10.0f,390.0f,0.0f),30.0f,15.0f); but[24].init(vec3(45.0f,390.0f,0.0f),30.0f,15.0f);
 but[25].init(vec3(80.0f,390.0f,0.0f),30.0f,15.0f); but[26].init(vec3(115.0f,390.0f,0.0f),30.0f,15.0f);

 but[27].init(vec3(10.0f,420.0f,0.0f),30.0f,15.0f); but[28].init(vec3(45.0f,420.0f,0.0f),30.0f,15.0f);
 but[29].init(vec3(80.0f,420.0f,0.0f),30.0f,15.0f); but[30].init(vec3(115.0f,420.0f,0.0f),30.0f,15.0f);

 but[31].init(vec3(10.0f,450.0f,0.0f),30.0f,15.0f); but[32].init(vec3(45.0f,450.0f,0.0f),30.0f,15.0f);
 but[33].init(vec3(80.0f,450.0f,0.0f),30.0f,15.0f); but[34].init(vec3(115.0f,450.0f,0.0f),30.0f,15.0f);

 but[35].init(vec3(10.0f,480.0f,0.0f),30.0f,15.0f); but[36].init(vec3(45.0f,480.0f,0.0f),30.0f,15.0f);
 but[37].init(vec3(80.0f,480.0f,0.0f),30.0f,15.0f); but[38].init(vec3(115.0f,480.0f,0.0f),30.0f,15.0f);

 but[39].init(vec3(10.0f,510.0f,0.0f),35.0f,15.0f);

 loopi(BUTNUM) but[i].set_tscale(0.3f,0.3f); // velkost textu tlacidiel

 // parametre a udaje tlacidiel
 but[0].set_data(lsrcparam.ambient.x); but[1].set_data(lsrcparam.ambient.y);
 but[2].set_data(lsrcparam.ambient.z); but[3].set_data(lsrcparam.ambient.w);

 but[4].set_data(lsrcparam.diffuse.x); but[5].set_data(lsrcparam.diffuse.y);
 but[6].set_data(lsrcparam.diffuse.z); but[7].set_data(lsrcparam.diffuse.w);

 but[8].set_data(lsrcparam.specular.x); but[9].set_data(lsrcparam.specular.y);
 but[10].set_data(lsrcparam.specular.z); but[11].set_data(lsrcparam.specular.w);

 but[12].set_range(-100.0f,100.0f); but[13].set_range(-100.0f,100.0f);
 but[14].set_range(-100.0f,100.0f);
 but[12].set_data(lsrcparam.position.x); but[13].set_data(lsrcparam.position.y);
 but[14].set_data(lsrcparam.position.z); but[15].set_data(lsrcparam.position.w);

 but[16].set_range(0.01f,1.0f);
 but[16].set_data(lsrcparam.constantAttenuation);
 but[17].set_data(lsrcparam.linearAttenuation);
 but[18].set_data(lsrcparam.quadraticAttenuation);

 but[19].set_data(lmodelparam.ambient.x); but[20].set_data(lmodelparam.ambient.y);
 but[21].set_data(lmodelparam.ambient.z); but[22].set_data(lmodelparam.ambient.w);

 but[23].set_data(mparam.ambient.x); but[24].set_data(mparam.ambient.y);
 but[25].set_data(mparam.ambient.z); but[26].set_data(mparam.ambient.w);

 but[27].set_data(mparam.diffuse.x); but[28].set_data(mparam.diffuse.y);
 but[29].set_data(mparam.diffuse.z); but[30].set_data(mparam.diffuse.w);

 but[31].set_data(mparam.specular.x); but[32].set_data(mparam.specular.y);
 but[33].set_data(mparam.specular.z); but[34].set_data(mparam.specular.w);

 but[35].set_data(mparam.emission.x); but[36].set_data(mparam.emission.y);
 but[37].set_data(mparam.emission.z); but[38].set_data(mparam.emission.w);

 but[39].set_range(0.0f,128.0f);
 but[39].set_cnum(5);
 but[39].set_data(mparam.shininess);

 but_id=-1; // index aktivneho tlacidla

 // Vertex Array Object
 glGenVertexArrays(1,&vao);
 glBindVertexArray(vao);

 // priprava objektov - kocka, gula, valec, ihlan, plochy
 objects_prepare();

 // inicializacia a nacitanie shaderov
 if (base_shader.init()) return(1);
 if (base_shader.load("shaders/base.vp","shaders/base.fp")) return(1);
 if (light_shader.init()) return(1);
 if (light_shader.load("shaders/light.vp","shaders/light.fp")) return(1);
 if (brick_shader.init()) return(1);
 if (brick_shader.load("shaders/brick.vp","shaders/brick.fp")) return(1);

 base_shader.on();
 base_shader.bindattriblocation(0,"in_pos"); // vrcholy
 base_shader.bindattriblocation(1,"in_col"); // farby
 base_shader.bindattriblocation(4,"in_nor"); // normaly
 base_shader.bindattriblocation(8,"in_uv");  // texturovacie suradnice
 base_shader.uniformI("base_tex_unit",0);    // zakladna texturovacia jednotka
 base_shader.uniformmatrixFV("projection_mat",avatar.get_pr_mat()); // projekcna matica
 base_shader.off();

 light_shader.on();
 light_shader.bindattriblocation(0,"in_pos"); // vrcholy
 light_shader.bindattriblocation(1,"in_col"); // farby
 light_shader.bindattriblocation(4,"in_nor"); // normaly
 light_shader.bindattriblocation(8,"in_uv");  // texturovacie suradnice
 light_shader.uniformI("base_tex_unit",0);    // zakladna texturovacia jednotka
 light_shader.uniformmatrixFV("projection_mat",avatar.get_pr_mat()); // projekcna matica
 light_shader.off();

 brick_shader.on();
 brick_shader.bindattriblocation(0,"in_pos"); // vrcholy
 brick_shader.bindattriblocation(4,"in_nor"); // normaly
 brick_shader.uniformmatrixFV("projection_mat",avatar.get_pr_mat()); // projekcna matica
 brick_shader.off();

 return(0);
}

// nastartovanie casovaca **************************************************
// 1s=1000ms
// Uint32 SDL_GetTicks() vracia pocet ms od startu SDL,
// po 49.7 dnoch dojde k prekroceniu 32bit limitu a pocitadlo sa vynuluje
void CInterface::resettimer(void)
{
 // aktualny casovy okamih (ms)
 actTime=(GLuint) SDL_GetTicks();
 // povodny casovy okamih (ms)
 oldTime=actTime;
 // pocet uplynutych milisekund
 millis=actTime-oldTime;
 // pomocne premenne
 fpsdelay=0; fpserror=0;

 // uplynuty cas medzi aktualnym a povodnym casovym okamihom (s)
 dTime=((GLfloat) millis)/1000.0f;

 // uplynute ms
 mspos=0; mstotal=0;
 // pocet snimkov za sekundu, minimalny a maximalny pocet snimkov za sekundu
 actfps=0; minfps=0; maxfps=0;
}

// aktualny pocet fps, minimalny a maximalny pocet fps *********************
void CInterface::getfps(GLuint &ACT,GLuint &MIN,GLuint &MAX)
{
 // posledny prvok pola uplynutych ms
 mstotal=mshistory[MSHISTORY-1]; MIN=mstotal; MAX=mstotal;
 // ostatne prvky pola
 loopi(MSHISTORY-1) {
  mstotal+=mshistory[i];
  if (mshistory[i]>MIN) MIN=mshistory[i];
  if (mshistory[i]<MAX) MAX=mshistory[i];
 }
 ACT=(1000*MSHISTORY)/mstotal; MIN=1000/MIN; MAX=1000/MAX;
}

// aktualizacia casovaca ***************************************************
void CInterface::updatetimer(void)
{
 // aktualny casovy okamih (ms)
 actTime=(GLuint) SDL_GetTicks();
 // aktualny casovy okamih nemoze byt "starsi" ako povodny casovy okamih
 if (actTime<oldTime) actTime=oldTime;
 // pocet uplynutych milisekund
 millis=actTime-oldTime;
 // uprava poctu uplynutych milisekund
 fpsdelay=1000/MAXFPS-millis;
 if (fpsdelay<=0) fpserror=0; // ak MAXFPS=200 => ak millis>=5
 else {
  fpserror+=1000%MAXFPS; // ak MAXFPS=200 => fpserror+=0
  if (fpserror>=MAXFPS) { fpserror-=MAXFPS; fpsdelay++; }
  if (fpsdelay>0) { // ak millis<5
   SDL_Delay(fpsdelay); // pauza
   actTime+=(GLuint) fpsdelay; // aktualny casovy okamih (ms)
   millis=actTime-oldTime; // pocet uplynutych milisekund
  }
 }

 // uplynuty cas medzi aktualnym a povodnym casovym okamihom (s)
 dTime=((GLfloat) millis)/1000.0f;
 oldTime=actTime;

 // aktualizacia pola uplynutych ms
 mshistory[mspos++]=(GLuint) max(1,min(1000,(int) millis));
 // po naplneni pola uplynutych ms sa vypocita actfps, minfps a maxfps
 if (mspos>=MSHISTORY) {
  mspos=0;
  // aktualny pocet fps, minimalny a maximalny pocet fps
  getfps(actfps,minfps,maxfps);
  // INFO: fps
  //printf("%u %u %u\n",actfps,minfps,maxfps);
 }
}

// casovo zavisla uprava objektov, resp. sceny *****************************
void CInterface::OGL_idle(void)
{

}

// aktualizacia paramterov osvetlenia **************************************
void CInterface::update_lighting_params(void)
{
 glLightfv(GL_LIGHT0,GL_AMBIENT,lsrcparam.ambient.get_data());
 glLightfv(GL_LIGHT0,GL_DIFFUSE,lsrcparam.diffuse.get_data());
 glLightfv(GL_LIGHT0,GL_SPECULAR,lsrcparam.specular.get_data());
 glLightfv(GL_LIGHT0,GL_SPOT_DIRECTION,lsrcparam.spotDirection.get_data());
 glLightf(GL_LIGHT0,GL_SPOT_EXPONENT,lsrcparam.spotExponent);
 glLightf(GL_LIGHT0,GL_SPOT_CUTOFF,lsrcparam.spotCutoff);
 glLightf(GL_LIGHT0,GL_CONSTANT_ATTENUATION,lsrcparam.constantAttenuation);
 glLightf(GL_LIGHT0,GL_LINEAR_ATTENUATION,lsrcparam.linearAttenuation);
 glLightf(GL_LIGHT0,GL_QUADRATIC_ATTENUATION,lsrcparam.quadraticAttenuation);

 glLightModelfv(GL_LIGHT_MODEL_AMBIENT,lmodelparam.ambient.get_data());

 glMaterialfv(GL_FRONT_AND_BACK,GL_AMBIENT,mparam.ambient.get_data());
 glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,mparam.diffuse.get_data());
 glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,mparam.specular.get_data());
 glMaterialfv(GL_FRONT_AND_BACK,GL_EMISSION,mparam.emission.get_data());
 glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,mparam.shininess);
}

// vykreslenie OpenGL sceny ************************************************
void CInterface::OGL_draw(void)
{
 // vymazanie zasobnika farieb, hlbky a Stencil zasobnika
 glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

 // modelview matica bude upravena podla transformacnej matice Avatara
 mvmat=avatar.get_mv_mat();
 // uprava modelview matice
 glLoadMatrixf(mvmat.get_data());
 // umiestnenie svetelneho zdroja na danu poziciu
 glLightfv(GL_LIGHT0,GL_POSITION,lsrcparam.position.get_data());
/*
 // vykreslenie objektov - kocka, gula, valec, ihlan, plochy
 base_shader.on();
 // modelview matica
 base_shader.uniformmatrixFV("modelview_mat",avatar.get_mv_mat());
 // pripojenie textury
 glBindTexture(GL_TEXTURE_2D,texture.tex_id[tid[1]]);
 objects_draw();
 base_shader.off();

 // vykreslenie objektov - kocka, gula, valec, ihlan, plochy
 light_shader.on();
 // modelview matica
 light_shader.uniformmatrixFV("modelview_mat",avatar.get_mv_mat());
 // pripojenie textury
 glBindTexture(GL_TEXTURE_2D,texture.tex_id[tid[1]]);
 objects_draw();
 light_shader.off();
*/
 // vykreslenie objektov - kocka, gula, valec, ihlan, plochy
 brick_shader.on();
 // modelview matica
 brick_shader.uniformmatrixFV("modelview_mat",avatar.get_mv_mat());
 // pripojenie textury
 glBindTexture(GL_TEXTURE_2D,texture.tex_id[tid[1]]);
 objects_draw();
 brick_shader.off();

 glColor4f(1.0f,1.0f,1.0f,1.0f); // biela
/*
 // vykreslenie TBN
 glPushAttrib(GL_TEXTURE_BIT);
 glDisable(GL_TEXTURE_2D);

 glBegin(GL_LINES);
  for (int i=0;i<4824;i+=3) {
   glColor4f(1.0f,0.0f,0.0f,1.0f);
   glVertex3f(v_a[i+0],v_a[i+1],v_a[i+2]);
   glVertex3f(v_a[i+0]+tan_a[i+0]/8.0f,v_a[i+1]+tan_a[i+1]/8.0f,v_a[i+2]+tan_a[i+2]/8.0f);
   glColor4f(0.0f,1.0f,0.0f,1.0f);
   glVertex3f(v_a[i+0],v_a[i+1],v_a[i+2]);
   glVertex3f(v_a[i+0]+bin_a[i+0]/8.0f,v_a[i+1]+bin_a[i+1]/8.0f,v_a[i+2]+bin_a[i+2]/8.0f);
   glColor4f(0.0f,0.0f,1.0f,1.0f);
   glVertex3f(v_a[i+0],v_a[i+1],v_a[i+2]);
   glVertex3f(v_a[i+0]+nor_a[i+0]/2.0f,v_a[i+1]+nor_a[i+1]/2.0f,v_a[i+2]+nor_a[i+2]/2.0f);
  }
 glEnd();

 glColor4f(1.0f,1.0f,1.0f,1.0f); // biela

 glPopAttrib();
*/
 // vykreslenie svetelneho zdroja
 // billboarding
 v[0].set(0.3f,0.0f,0.0f);
 s.x=(v[0].x*mvmat[0]);//+v[0].y*mvmat[1]+v[0].z*mvmat[2]);
 s.y=(v[0].x*mvmat[4]);//+v[0].y*mvmat[5]+v[0].z*mvmat[6]);
 s.z=(v[0].x*mvmat[8]);//+v[0].y*mvmat[9]+v[0].z*mvmat[10]);
 v[0].set(0.0f,0.3f,0.0f);
 t.x=(/*v[0].x*mvmat[0]+*/v[0].y*mvmat[1]);//+v[0].z*mvmat[2]);
 t.y=(/*v[0].x*mvmat[4]+*/v[0].y*mvmat[5]);//+v[0].z*mvmat[6]);
 t.z=(/*v[0].x*mvmat[8]+*/v[0].y*mvmat[9]);//+v[0].z*mvmat[10]);
 v[0].set(-s.x-t.x,-s.y-t.y,-s.z-t.z); // 1. vrchol
 v[1].set( s.x-t.x, s.y-t.y, s.z-t.z); // 2. vrchol
 v[2].set( s.x+t.x, s.y+t.y, s.z+t.z); // 3. vrchol
 v[3].set(-s.x+t.x,-s.y+t.y,-s.z+t.z); // 4. vrchol

 glEnable(GL_BLEND);
 glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
 glBindTexture(GL_TEXTURE_2D,texture.tex_id[tid[10]]);
 glTranslatef(lsrcparam.position.x,lsrcparam.position.y,lsrcparam.position.z);
 glBegin(GL_QUADS);
  glTexCoord2f(0.0f,0.0f); glVertex3fv(v[0].get_data());
  glTexCoord2f(1.0f,0.0f); glVertex3fv(v[1].get_data());
  glTexCoord2f(1.0f,1.0f); glVertex3fv(v[2].get_data());
  glTexCoord2f(0.0f,1.0f); glVertex3fv(v[3].get_data());
 glEnd();
 glDisable(GL_BLEND);

 // vykreslenie head-up display
 drawhud();
}

// vykreslenie head-up display *********************************************
void CInterface::drawhud(void)
{
 // ulozenie potrebnych atributov
 glPushAttrib(GL_DEPTH_BUFFER_BIT);

 glDisable(GL_DEPTH_TEST); // vypnutie testu hlbky
 glEnable(GL_BLEND);       // zapnutie priesvitnosti

 glMatrixMode(GL_PROJECTION); // projekcna matica
 glPushMatrix();              // ulozenie
 glLoadIdentity();            // reset

 // nastavenie pravouhleho premietania - vymeni Y
 glOrtho(0.0f,(GLfloat) scr_w,(GLfloat) scr_h,0.0f,-1.0f,1.0f);

 glMatrixMode(GL_MODELVIEW); // modelview matica
 glPushMatrix();             // ulozenie
 glLoadIdentity();           // reset

 // funkcia pre vypocet priesvitnosti
 glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_ALPHA);

 // vykreslenie menu -------------------------------------------------------

 // pripojenie prazdnej textury
 glBindTexture(GL_TEXTURE_2D,texture.tex_id[tid[0]]);
 // farba (priesvitnost) menu
 glColor4f(1.0f,1.0f,1.0f,0.1f);
 // stvoruholnik
 glBegin(GL_QUADS); // glOrtho() vymeni Y
  glVertex3f(5.0f,  5.0f,               0.0f);
  glVertex3f(5.0f,  (GLfloat) (scr_h-5),0.0f);
  glVertex3f(150.f, (GLfloat) (scr_h-5),0.0f);
  glVertex3f(150.0f,5.0f,               0.0f);
 glEnd();

 // vykreslenie tlacidiel
 loopi(BUTNUM) but[i].draw();

 // vypis textu ------------------------------------------------------------

 // pripojenie textury s fontom
 glBindTexture(GL_TEXTURE_2D,text.tex_id);

 // velkost textu
 text.scale(0.5f,0.5f);
 // farba textu
 glColor4f(0.8f,0.8f,0.0f,1.0f);
 // pocet fps
 text.drawf(15.0f,15.0f,"%u",actfps);
 // poloha Avatara
 text.drawf(15.0f,45.0f,"%.1f %.1f %.1f",avatar.actpos.x,avatar.actpos.y,avatar.actpos.z);

 // velkost textu
 text.scale(0.4f,0.4f);
 // parametre svetelneho zdroja
 glColor4f(0.8f,0.8f,0.8f,1.0f); text.drawf(25.0f,157.0f,"Light source");
 glColor4f(0.8f,0.8f,0.0f,1.0f);
 text.drawf(25.0f,192.0,"ambient:");
 text.drawf(25.0f,267.0,"diffuse:");
 text.drawf(25.0f,342.0f,"specular:");
 text.drawf(25.0f,417.0f,"position:");
 text.drawf(25.0f,492.0f,"constantAtt:");
 text.drawf(25.0f,567.0f,"linearAtt:");
 text.drawf(25.0f,642.0f,"quadraticAtt:");
 text.drawf(25.0f,792.0f,"global ambient:");
 // parametre materialu
 glColor4f(0.8f,0.8f,0.8f,1.0f); text.drawf(25.0f,907.0f,"Material");
 glColor4f(0.8f,0.8f,0.0f,1.0f);
 text.drawf(25.0f,942.0f,"ambient:");
 text.drawf(25.0f,1017.0f,"diffuse:");
 text.drawf(25.0f,1092.0f,"specular:");
 text.drawf(25.0f,1167.0f,"emission:");
 text.drawf(25.0f,1242.0f,"shininess:");

 // vykreslenie zameriavacieho kriza ---------------------------------------

 // funkcia pre vypocet priesvitnosti
 glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_COLOR);

 // farba zameriavacieho kriza
 glColor4f(0.5f,0.5f,0.5f,1.0f);
 // pripojenie textury zameriavacieho kriza
 glBindTexture(GL_TEXTURE_2D,texture.tex_id[tid[2]]);

 glPushMatrix(); // ulozenie modelview matice
 // zameriavaci kriz na stred okna
 glTranslatef((GLfloat) scr_w2-crosshairSize/2.0f,
              (GLfloat) scr_h2-crosshairSize/2.0f,0.0f);
 // stvoruholnik
 glBegin(GL_QUADS); // glOrtho() vymeni Y
  glTexCoord2f(0.0f,0.0f); glVertex3f(0.0f,0.0f,0.0f);
  glTexCoord2f(0.0f,1.0f); glVertex3f(0.0f,crosshairSize,0.0f);
  glTexCoord2f(1.0f,1.0f); glVertex3f(crosshairSize,crosshairSize,0.0f);
  glTexCoord2f(1.0f,0.0f); glVertex3f(crosshairSize,0.0f,0.0f);
 glEnd();
 glPopMatrix(); // obnova modelview matice

 glColor4f(1.0f,1.0f,1.0f,1.0f); // biela

 glPopMatrix(); // obnova modelview matice
 glMatrixMode(GL_PROJECTION);
 glPopMatrix(); // obnova projection matice

 // aktualna je vzdy modelview matica
 glMatrixMode(GL_MODELVIEW);

 glDisable(GL_BLEND); // vypnutie priesvitnosti
 glPopAttrib();       // vyber ulozenych atributov - DEPTH_BUFFER
}

// vypocet TBN vektorov ****************************************************
void CInterface::TBN(int E,int Q,int W)
{
 vec3 v0,v1,v2;
 vec2 v0t,v1t,v2t;
 vec3 tan,bin,nor;

 v0.set(v_a[E+Q+0],v_a[E+Q+1],v_a[E+Q+2]); // 3 vrcholy
 v1.set(v_a[E+Q+3],v_a[E+Q+4],v_a[E+Q+5]);
 v2.set(v_a[E+Q+6],v_a[E+Q+7],v_a[E+Q+8]);
 v0t.set(t_a[72+W+0],t_a[72+W+1]);         // 3 texturovacie suradnice
 v1t.set(t_a[72+W+2],t_a[72+W+3]);
 v2t.set(t_a[72+W+4],t_a[72+W+5]);
 mm.calc_tbn(v0,v1,v2,v0t,v1t,v2t,tan,bin,nor); // vypocet TBN
 tan_a[E+Q+0]=tan.x; tan_a[E+Q+1]=tan.y; tan_a[E+Q+2]=tan.z; // 1. vrchol
 tan_a[E+Q+3]=tan.x; tan_a[E+Q+4]=tan.y; tan_a[E+Q+5]=tan.z; // 2. vrchol
 tan_a[E+Q+6]=tan.x; tan_a[E+Q+7]=tan.y; tan_a[E+Q+8]=tan.z; // 3. vrchol
 bin_a[E+Q+0]=bin.x; bin_a[E+Q+1]=bin.y; bin_a[E+Q+2]=bin.z; // 1. vrchol
 bin_a[E+Q+3]=bin.x; bin_a[E+Q+4]=bin.y; bin_a[E+Q+5]=bin.z; // 2. vrchol
 bin_a[E+Q+6]=bin.x; bin_a[E+Q+7]=bin.y; bin_a[E+Q+8]=bin.z; // 3. vrchol
 nor_a[E+Q+0]=nor.x; nor_a[E+Q+1]=nor.y; nor_a[E+Q+2]=nor.z; // 1. vrchol
 nor_a[E+Q+3]=nor.x; nor_a[E+Q+4]=nor.y; nor_a[E+Q+5]=nor.z; // 2. vrchol
 nor_a[E+Q+6]=nor.x; nor_a[E+Q+7]=nor.y; nor_a[E+Q+8]=nor.z; // 3. vrchol
}

// priprava objektov - kocka, gula, valec, ihlan, plochy *******************
void CInterface::objects_prepare(void)
{
 // pomocne premenne
 int q=0,w=0,e=0,f=0,r=0,s=0,t=0;
 float alfa[2],beta[2];
 float x[4],y[2],z[4];
 vec3 n[7];

 e=108; // pocet udajov patriacich kocke

 // kocka ------------------------------------------------------------------
 float tmp[]={-4.0f, 0.0f, 4.0f,-2.0f, 0.0f, 4.0f,-2.0f, 2.0f, 4.0f,
              -4.0f, 0.0f, 4.0f,-2.0f, 2.0f, 4.0f,-4.0f, 2.0f, 4.0f,
              -2.0f, 0.0f, 4.0f,-2.0f, 0.0f, 2.0f,-2.0f, 2.0f, 2.0f,
              -2.0f, 0.0f, 4.0f,-2.0f, 2.0f, 2.0f,-2.0f, 2.0f, 4.0f,
              -2.0f, 0.0f, 2.0f,-4.0f, 0.0f, 2.0f,-4.0f, 2.0f, 2.0f,
              -2.0f, 0.0f, 2.0f,-4.0f, 2.0f, 2.0f,-2.0f, 2.0f, 2.0f,
              -4.0f, 0.0f, 2.0f,-4.0f, 0.0f, 4.0f,-4.0f, 2.0f, 4.0f,
              -4.0f, 0.0f, 2.0f,-4.0f, 2.0f, 4.0f,-4.0f, 2.0f, 2.0f,
              -4.0f, 2.0f, 4.0f,-2.0f, 2.0f, 4.0f,-2.0f, 2.0f, 2.0f,
              -4.0f, 2.0f, 4.0f,-2.0f, 2.0f, 2.0f,-4.0f, 2.0f, 2.0f,
              -4.0f, 0.0f, 2.0f,-2.0f, 0.0f, 2.0f,-2.0f, 0.0f, 4.0f,
              -4.0f, 0.0f, 2.0f,-2.0f, 0.0f, 4.0f,-4.0f, 0.0f, 4.0f};
 loopi(e) v_a[i]=tmp[i];
 // farby
 for (int i=0;i<e;i+=3) { c_a[i]=0.5f; c_a[i+1]=0.0f; c_a[i+2]=0.0f; }
 // normaly
 float tmp1[]={ 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f,
                0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f,
                1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f,
                1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f,
                0.0f, 0.0f,-1.0f, 0.0f, 0.0f,-1.0f, 0.0f, 0.0f,-1.0f,
                0.0f, 0.0f,-1.0f, 0.0f, 0.0f,-1.0f, 0.0f, 0.0f,-1.0f,
               -1.0f, 0.0f, 0.0f,-1.0f, 0.0f, 0.0f,-1.0f, 0.0f, 0.0f,
               -1.0f, 0.0f, 0.0f,-1.0f, 0.0f, 0.0f,-1.0f, 0.0f, 0.0f,
                0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f,
                0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f,
                0.0f,-1.0f, 0.0f, 0.0f,-1.0f, 0.0f, 0.0f,-1.0f, 0.0f,
                0.0f,-1.0f, 0.0f, 0.0f,-1.0f, 0.0f, 0.0f,-1.0f, 0.0f};
 loopi(e) nor_a[i]=tmp1[i];
 // texturovacie suradnice
 float tmp2[]={0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f,
               0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
 loopi(72) t_a[i]=tmp2[i];

 f=e+q; // zaciatok udajov gule

 // gula -------------------------------------------------------------------
 loopj(180) {
  if (j%segs) continue;
  loopi(360) {
   if (i%segs) continue;

   alfa[0]=DEG2RAD((float) i);        beta[0]=DEG2RAD((float) j);
   alfa[1]=DEG2RAD((float) (i+segs)); beta[1]=DEG2RAD((float) (j+segs));

   x[0]=3.0f+cos(alfa[0])*sin(beta[0]); x[1]=3.0f+cos(alfa[1])*sin(beta[0]);
   x[2]=3.0f+cos(alfa[1])*sin(beta[1]); x[3]=3.0f+cos(alfa[0])*sin(beta[1]);
   y[0]=1.0f+cos(beta[0]); y[1]=1.0f+cos(beta[1]);
   z[0]=3.0f+sin(alfa[0])*sin(beta[0]); z[1]=3.0f+sin(alfa[1])*sin(beta[0]);
   z[2]=3.0f+sin(alfa[1])*sin(beta[1]); z[3]=3.0f+sin(alfa[0])*sin(beta[1]);

   v_a[e+q+0]=x[0]; v_a[e+q+1]=y[0]; v_a[e+q+2]=z[0]; // 1. vrchol
   v_a[e+q+3]=x[1]; v_a[e+q+4]=y[0]; v_a[e+q+5]=z[1]; // 2. vrchol
   v_a[e+q+6]=x[2]; v_a[e+q+7]=y[1]; v_a[e+q+8]=z[2]; // 3. vrchol
   c_a[e+q+0]=0.0f; c_a[e+q+1]=0.5f; c_a[e+q+2]=0.0f; // 1. vrchol
   c_a[e+q+3]=0.0f; c_a[e+q+4]=0.5f; c_a[e+q+5]=0.0f; // 2. vrchol
   c_a[e+q+6]=0.0f; c_a[e+q+7]=0.5f; c_a[e+q+8]=0.0f; // 3. vrchol
   t_a[72+w+0]=(float) i/90.0f;        t_a[72+w+1]=(float) j/90.0f;        // 1. vrchol
   t_a[72+w+2]=(float) (i+segs)/90.0f; t_a[72+w+3]=(float) j/90.0f;        // 2. vrchol
   t_a[72+w+4]=(float) (i+segs)/90.0f; t_a[72+w+5]=(float) (j+segs)/90.0f; // 3. vrchol
   TBN(e,q,w);
   q+=9; w+=6;

   v_a[e+q+0]=x[0]; v_a[e+q+1]=y[0]; v_a[e+q+2]=z[0]; // 1. vrchol
   v_a[e+q+3]=x[2]; v_a[e+q+4]=y[1]; v_a[e+q+5]=z[2]; // 2. vrchol
   v_a[e+q+6]=x[3]; v_a[e+q+7]=y[1]; v_a[e+q+8]=z[3]; // 3. vrchol
   c_a[e+q+0]=0.0f; c_a[e+q+1]=0.5f; c_a[e+q+2]=0.0f; // 1. vrchol
   c_a[e+q+3]=0.0f; c_a[e+q+4]=0.5f; c_a[e+q+5]=0.0f; // 2. vrchol
   c_a[e+q+6]=0.0f; c_a[e+q+7]=0.5f; c_a[e+q+8]=0.0f; // 3. vrchol
   t_a[72+w+0]=(float) i/90.0f;        t_a[72+w+1]=(float) j/90.0f;        // 1. vrchol
   t_a[72+w+2]=(float) (i+segs)/90.0f; t_a[72+w+3]=(float) (j+segs)/90.0f; // 2. vrchol
   t_a[72+w+4]=(float) i/90.0f;        t_a[72+w+5]=(float) (j+segs)/90.0f; // 3. vrchol
   TBN(e,q,w);
   q+=9; w+=6;
  }
 }
 // vyhladenie normal
 t=18*(360/segs);
 loopj(180) {
  if ((j==0) || (j%segs)) continue;
  loopi(360) {
   if (i%segs) continue;
   r=i+j*(360/segs);
   s=i+(j-segs)*(360/segs);
   if (i==0) {
    n[0].set(nor_a[f+r+0],   nor_a[f+r+1],   nor_a[f+r+2]);
    n[1].set(nor_a[f+r+9],   nor_a[f+r+10],  nor_a[f+r+11]);
    n[2].set(nor_a[f+r+t-15],nor_a[f+r+t-14],nor_a[f+r+t-13]);
    n[3].set(nor_a[f+s+t-6], nor_a[f+s+t-5], nor_a[f+s+t-4]);
    n[4].set(nor_a[f+s+t-12],nor_a[f+s+t-11],nor_a[f+s+t-10]);
    n[5].set(nor_a[f+s+15],  nor_a[f+s+16],  nor_a[f+s+17]);
    n[6]=(n[0]+n[1]+n[2]+n[3]+n[4]+n[5])/6.0f; n[6].normalize();
    nor_a[f+r+0]=   n[6].x; nor_a[f+r+1]=   n[6].y; nor_a[f+r+2]=   n[6].z;
    nor_a[f+r+9]=   n[6].x; nor_a[f+r+10]=  n[6].y; nor_a[f+r+11]=  n[6].z;
    nor_a[f+r+t-15]=n[6].x; nor_a[f+r+t-14]=n[6].y; nor_a[f+r+t-13]=n[6].z;
    nor_a[f+s+t-6]= n[6].x; nor_a[f+s+t-5]= n[6].y; nor_a[f+s+t-4]= n[6].z;
    nor_a[f+s+t-12]=n[6].x; nor_a[f+s+t-11]=n[6].y; nor_a[f+s+t-10]=n[6].z;
    nor_a[f+s+15]=  n[6].x; nor_a[f+s+16]=  n[6].y; nor_a[f+s+17]=  n[6].z;
   }
   else {
    n[0].set(nor_a[f+r+0], nor_a[f+r+1], nor_a[f+r+2]);
    n[1].set(nor_a[f+r+9], nor_a[f+r+10],nor_a[f+r+11]);
    n[2].set(nor_a[f+r-15],nor_a[f+r-14],nor_a[f+r-13]);
    n[3].set(nor_a[f+s-6], nor_a[f+s-5], nor_a[f+s-4]);
    n[4].set(nor_a[f+s-12],nor_a[f+s-11],nor_a[f+s-10]);
    n[5].set(nor_a[f+s+15],nor_a[f+s+16],nor_a[f+s+17]);
    n[6]=(n[0]+n[1]+n[2]+n[3]+n[4]+n[5])/6.0f; n[6].normalize();
    nor_a[f+r+0]= n[6].x; nor_a[f+r+1]= n[6].y; nor_a[f+r+2]= n[6].z;
    nor_a[f+r+9]= n[6].x; nor_a[f+r+10]=n[6].y; nor_a[f+r+11]=n[6].z;
    nor_a[f+r-15]=n[6].x; nor_a[f+r-14]=n[6].y; nor_a[f+r-13]=n[6].z;
    nor_a[f+s-6]= n[6].x; nor_a[f+s-5]= n[6].y; nor_a[f+s-4]= n[6].z;
    nor_a[f+s-12]=n[6].x; nor_a[f+s-11]=n[6].y; nor_a[f+s-10]=n[6].z;
    nor_a[f+s+15]=n[6].x; nor_a[f+s+16]=n[6].y; nor_a[f+s+17]=n[6].z;
   }
  }
 }

 f=e+q; // zaciatok udajov valca

 // valec ------------------------------------------------------------------
 loopi(360) {
  if (i%segs) continue;

  alfa[0]=DEG2RAD((float) i);
  alfa[1]=DEG2RAD((float) (i+segs));

  x[0]=3.0f+cos(alfa[0]); x[1]=3.0f+cos(alfa[1]);
  y[0]=0.0f; y[1]=2.0f;
  z[0]=-3.0f-sin(alfa[0]); z[1]=-3.0f-sin(alfa[1]);

  v_a[e+q+0]=x[0]; v_a[e+q+1]=y[0]; v_a[e+q+2]=z[0]; // 1. vrchol
  v_a[e+q+3]=x[1]; v_a[e+q+4]=y[0]; v_a[e+q+5]=z[1]; // 2. vrchol
  v_a[e+q+6]=x[1]; v_a[e+q+7]=y[1]; v_a[e+q+8]=z[1]; // 3. vrchol
  c_a[e+q+0]=0.0f; c_a[e+q+1]=0.0f; c_a[e+q+2]=0.5f; // 1. vrchol
  c_a[e+q+3]=0.0f; c_a[e+q+4]=0.0f; c_a[e+q+5]=0.5f; // 2. vrchol
  c_a[e+q+6]=0.0f; c_a[e+q+7]=0.0f; c_a[e+q+8]=0.5f; // 3. vrchol
  t_a[72+w+0]=(float) i/90.0f;        t_a[72+w+1]=0.0f; // 1. vrchol
  t_a[72+w+2]=(float) (i+segs)/90.0f; t_a[72+w+3]=0.0f; // 2. vrchol
  t_a[72+w+4]=(float) (i+segs)/90.0f; t_a[72+w+5]=1.0f; // 3. vrchol
  TBN(e,q,w);
  q+=9; w+=6;

  v_a[e+q+0]=x[0]; v_a[e+q+1]=y[0]; v_a[e+q+2]=z[0]; // 1. vrchol
  v_a[e+q+3]=x[1]; v_a[e+q+4]=y[1]; v_a[e+q+5]=z[1]; // 2. vrchol
  v_a[e+q+6]=x[0]; v_a[e+q+7]=y[1]; v_a[e+q+8]=z[0]; // 3. vrchol
  c_a[e+q+0]=0.0f; c_a[e+q+1]=0.0f; c_a[e+q+2]=0.5f; // 1. vrchol
  c_a[e+q+3]=0.0f; c_a[e+q+4]=0.0f; c_a[e+q+5]=0.5f; // 2. vrchol
  c_a[e+q+6]=0.0f; c_a[e+q+7]=0.0f; c_a[e+q+8]=0.5f; // 3. vrchol
  t_a[72+w+0]=(float) i/90.0f;        t_a[72+w+1]=0.0f; // 1. vrchol
  t_a[72+w+2]=(float) (i+segs)/90.0f; t_a[72+w+3]=1.0f; // 2. vrchol
  t_a[72+w+4]=(float) i/90.0f;        t_a[72+w+5]=1.0f; // 3. vrchol
  TBN(e,q,w);
  q+=9; w+=6;

  v_a[e+q+0]=x[0]; v_a[e+q+1]=2.0f; v_a[e+q+2]=z[0];  // 1. vrchol
  v_a[e+q+3]=x[1]; v_a[e+q+4]=2.0f; v_a[e+q+5]=z[1];  // 2. vrchol
  v_a[e+q+6]=3.0f; v_a[e+q+7]=2.0f; v_a[e+q+8]=-3.0f; // 3. vrchol
  c_a[e+q+0]=0.0f; c_a[e+q+1]=0.0f; c_a[e+q+2]=0.5f; // 1. vrchol
  c_a[e+q+3]=0.0f; c_a[e+q+4]=0.0f; c_a[e+q+5]=0.5f; // 2. vrchol
  c_a[e+q+6]=0.0f; c_a[e+q+7]=0.0f; c_a[e+q+8]=0.5f; // 3. vrchol
  t_a[72+w+0]=0.0f; t_a[72+w+1]=0.0f; // 1. vrchol
  t_a[72+w+2]=0.1f; t_a[72+w+3]=0.0f; // 2. vrchol
  t_a[72+w+4]=0.1f; t_a[72+w+5]=1.0f; // 3. vrchol
  TBN(e,q,w);
  q+=9; w+=6;

  v_a[e+q+0]=x[1]; v_a[e+q+1]=0.0f; v_a[e+q+2]=z[1];  // 1. vrchol
  v_a[e+q+3]=x[0]; v_a[e+q+4]=0.0f; v_a[e+q+5]=z[0];  // 2. vrchol
  v_a[e+q+6]=3.0f; v_a[e+q+7]=0.0f; v_a[e+q+8]=-3.0f; // 3. vrchol
  c_a[e+q+0]=0.0f; c_a[e+q+1]=0.0f; c_a[e+q+2]=0.5f; // 1. vrchol
  c_a[e+q+3]=0.0f; c_a[e+q+4]=0.0f; c_a[e+q+5]=0.5f; // 2. vrchol
  c_a[e+q+6]=0.0f; c_a[e+q+7]=0.0f; c_a[e+q+8]=0.5f; // 3. vrchol
  t_a[72+w+0]=0.0f; t_a[72+w+1]=0.0f; // 1. vrchol
  t_a[72+w+2]=0.1f; t_a[72+w+3]=0.0f; // 2. vrchol
  t_a[72+w+4]=0.1f; t_a[72+w+5]=1.0f; // 3. vrchol
  TBN(e,q,w);
  q+=9; w+=6;
 }
 // vyhladenie normal
 t=36*(360/segs);
 for (int i=0;i<36*(360/segs);i+=36) {
  if (i==0) {
   n[0].set(nor_a[f+i+0],   nor_a[f+i+1],   nor_a[f+i+2]);
   n[1].set(nor_a[f+i+9],   nor_a[f+i+10],  nor_a[f+i+11]);
   n[2].set(nor_a[f+i+t-33],nor_a[f+i+t-32],nor_a[f+i+t-31]);
   n[3].set(nor_a[f+i+15],  nor_a[f+i+16],  nor_a[f+i+17]);
   n[4].set(nor_a[f+i+t-30],nor_a[f+i+t-29],nor_a[f+i+t-28]);
   n[5].set(nor_a[f+i+t-24],nor_a[f+i+t-23],nor_a[f+i+t-22]);
   n[6]=(n[0]+n[1]+n[2])/3.0f; n[6].normalize();
   nor_a[f+i+0]=   n[6].x; nor_a[f+i+1]=   n[6].y; nor_a[f+i+2]=   n[6].z;
   nor_a[f+i+9]=   n[6].x; nor_a[f+i+10]=  n[6].y; nor_a[f+i+11]=  n[6].z;
   nor_a[f+i+t-33]=n[6].x; nor_a[f+i+t-32]=n[6].y; nor_a[f+i+t-31]=n[6].z;
   n[6]=(n[3]+n[4]+n[5])/3.0f; n[6].normalize();
   nor_a[f+i+15]=  n[6].x; nor_a[f+i+16]=  n[6].y; nor_a[f+i+17]=  n[6].z;
   nor_a[f+i+t-30]=n[6].x; nor_a[f+i+t-29]=n[6].y; nor_a[f+i+t-28]=n[6].z;
   nor_a[f+i+t-24]=n[6].x; nor_a[f+i+t-23]=n[6].y; nor_a[f+i+t-22]=n[6].z;
  }
  else {
   n[0].set(nor_a[f+i+0], nor_a[f+i+1], nor_a[f+i+2]);
   n[1].set(nor_a[f+i+9], nor_a[f+i+10],nor_a[f+i+11]);
   n[2].set(nor_a[f+i-33],nor_a[f+i-32],nor_a[f+i-31]);
   n[3].set(nor_a[f+i+15],nor_a[f+i+16],nor_a[f+i+17]);
   n[4].set(nor_a[f+i-30],nor_a[f+i-29],nor_a[f+i-28]);
   n[5].set(nor_a[f+i-24],nor_a[f+i-23],nor_a[f+i-22]);
   n[6]=(n[0]+n[1]+n[2])/3.0f; n[6].normalize();
   nor_a[f+i+0]= n[6].x; nor_a[f+i+1]= n[6].y; nor_a[f+i+2]= n[6].z;
   nor_a[f+i+9]= n[6].x; nor_a[f+i+10]=n[6].y; nor_a[f+i+11]=n[6].z;
   nor_a[f+i-33]=n[6].x; nor_a[f+i-32]=n[6].y; nor_a[f+i-31]=n[6].z;
   n[6]=(n[3]+n[4]+n[5])/3.0f; n[6].normalize();
   nor_a[f+i+15]=n[6].x; nor_a[f+i+16]=n[6].y; nor_a[f+i+17]=n[6].z;
   nor_a[f+i-30]=n[6].x; nor_a[f+i-29]=n[6].y; nor_a[f+i-28]=n[6].z;
   nor_a[f+i-24]=n[6].x; nor_a[f+i-23]=n[6].y; nor_a[f+i-22]=n[6].z;
  }
 }

 f=e+q; // zaciatok udajov ihlanu

 // ihlan ------------------------------------------------------------------
 loopi(360) {
  if (i%segs) continue;

  alfa[0]=DEG2RAD((float) i);
  alfa[1]=DEG2RAD((float) (i+segs));

  x[0]=-3.0f+cos(alfa[0]); x[1]=-3.0f+cos(alfa[1]);
  y[0]=0.0f; y[1]=2.0f;
  z[0]=-3.0f-sin(alfa[0]); z[1]=-3.0f-sin(alfa[1]);

  v_a[e+q+0]=x[0];  v_a[e+q+1]=y[0]; v_a[e+q+2]=z[0];  // 1. vrchol
  v_a[e+q+3]=x[1];  v_a[e+q+4]=y[0]; v_a[e+q+5]=z[1];  // 2. vrchol
  v_a[e+q+6]=-3.0f; v_a[e+q+7]=y[1]; v_a[e+q+8]=-3.0f; // 3. vrchol
  c_a[e+q+0]=0.5f; c_a[e+q+1]=0.5f; c_a[e+q+2]=0.0f; // 1. vrchol
  c_a[e+q+3]=0.5f; c_a[e+q+4]=0.5f; c_a[e+q+5]=0.0f; // 2. vrchol
  c_a[e+q+6]=0.5f; c_a[e+q+7]=0.5f; c_a[e+q+8]=0.0f; // 3. vrchol
  t_a[72+w+0]=0.0f; t_a[72+w+1]=0.0f; // 1. vrchol
  t_a[72+w+2]=0.1f; t_a[72+w+3]=0.0f; // 2. vrchol
  t_a[72+w+4]=0.1f; t_a[72+w+5]=1.0f; // 3. vrchol
  TBN(e,q,w);
  q+=9; w+=6;

  v_a[e+q+0]=x[1];  v_a[e+q+1]=0.0f; v_a[e+q+2]=z[1];  // 1. vrchol
  v_a[e+q+3]=x[0];  v_a[e+q+4]=0.0f; v_a[e+q+5]=z[0];  // 2. vrchol
  v_a[e+q+6]=-3.0f; v_a[e+q+7]=0.0f; v_a[e+q+8]=-3.0f; // 3. vrchol
  c_a[e+q+0]=0.5f; c_a[e+q+1]=0.5f; c_a[e+q+2]=0.0f; // 1. vrchol
  c_a[e+q+3]=0.5f; c_a[e+q+4]=0.5f; c_a[e+q+5]=0.0f; // 2. vrchol
  c_a[e+q+6]=0.5f; c_a[e+q+7]=0.5f; c_a[e+q+8]=0.0f; // 3. vrchol
  t_a[72+w+0]=0.0f; t_a[72+w+1]=0.0f; // 1. vrchol
  t_a[72+w+2]=0.1f; t_a[72+w+3]=0.0f; // 2. vrchol
  t_a[72+w+4]=0.1f; t_a[72+w+5]=1.0f; // 3. vrchol
  TBN(e,q,w);
  q+=9; w+=6;
 }
 // vyhladenie normal
 t=18*(360/segs);
 for (int i=0;i<18*(360/segs);i+=18) {
  if (i==0) {
   n[0].set(nor_a[f+i+0],   nor_a[f+i+1],   nor_a[f+i+2]);
   n[1].set(nor_a[f+i+t-15],nor_a[f+i+t-14],nor_a[f+i+t-13]);
   n[6]=(n[0]+n[1])/2.0f; n[6].normalize();
   nor_a[f+i+0]=   n[6].x; nor_a[f+i+1]=   n[6].y; nor_a[f+i+2]=   n[6].z;
   nor_a[f+i+t-15]=n[6].x; nor_a[f+i+t-14]=n[6].y; nor_a[f+i+t-13]=n[6].z;
   nor_a[f+i+6]=   0.0f; nor_a[f+i+7]=   1.0f; nor_a[f+i+8]=   0.0f;
   nor_a[f+i+t-12]=0.0f; nor_a[f+i+t-11]=1.0f; nor_a[f+i+t-10]=0.0f;
  }
  else {
   n[0].set(nor_a[f+i+0], nor_a[f+i+1], nor_a[f+i+2]);
   n[1].set(nor_a[f+i-15],nor_a[f+i-14],nor_a[f+i-13]);
   n[2].set(nor_a[f+i+6], nor_a[f+i+7], nor_a[f+i+8]);
   n[3].set(nor_a[f+i-12],nor_a[f+i-11],nor_a[f+i-10]);
   n[6]=(n[0]+n[1])/2.0f; n[6].normalize();
   nor_a[f+i+0]= n[6].x; nor_a[f+i+1]= n[6].y; nor_a[f+i+2]= n[6].z;
   nor_a[f+i-15]=n[6].x; nor_a[f+i-14]=n[6].y; nor_a[f+i-13]=n[6].z;
   nor_a[f+i+6]= 0.0f; nor_a[f+i+7]= 1.0f; nor_a[f+i+8]= 0.0f;
   nor_a[f+i-12]=0.0f; nor_a[f+i-11]=1.0f; nor_a[f+i-10]=0.0f;
  }
 }

 // plochy -----------------------------------------------------------------
 v_a[e+q+0]=-5.0f; v_a[e+q+1]=0.0f; v_a[e+q+2]= 5.0f; // 1. vrchol
 v_a[e+q+3]= 5.0f; v_a[e+q+4]=0.0f; v_a[e+q+5]= 5.0f; // 2. vrchol
 v_a[e+q+6]= 5.0f; v_a[e+q+7]=0.0f; v_a[e+q+8]=-5.0f; // 3. vrchol
 c_a[e+q+0]=0.2f; c_a[e+q+1]=0.2f; c_a[e+q+2]=0.2f; // 1. vrchol
 c_a[e+q+3]=0.2f; c_a[e+q+4]=0.2f; c_a[e+q+5]=0.2f; // 2. vrchol
 c_a[e+q+6]=0.2f; c_a[e+q+7]=0.2f; c_a[e+q+8]=0.2f; // 3. vrchol
 t_a[72+w+0]=0.0f; t_a[72+w+1]=0.0f; // 1. vrchol
 t_a[72+w+2]=1.0f; t_a[72+w+3]=0.0f; // 2. vrchol
 t_a[72+w+4]=1.0f; t_a[72+w+5]=1.0f; // 3. vrchol
 TBN(e,q,w);
 q+=9; w+=6;

 v_a[e+q+0]=-5.0f; v_a[e+q+1]=0.0f; v_a[e+q+2]= 5.0f; // 1. vrchol
 v_a[e+q+3]= 5.0f; v_a[e+q+4]=0.0f; v_a[e+q+5]=-5.0f; // 2. vrchol
 v_a[e+q+6]=-5.0f; v_a[e+q+7]=0.0f; v_a[e+q+8]=-5.0f; // 3. vrchol
 c_a[e+q+0]=0.2f; c_a[e+q+1]=0.2f; c_a[e+q+2]=0.2f; // 1. vrchol
 c_a[e+q+3]=0.2f; c_a[e+q+4]=0.2f; c_a[e+q+5]=0.2f; // 2. vrchol
 c_a[e+q+6]=0.2f; c_a[e+q+7]=0.2f; c_a[e+q+8]=0.2f; // 3. vrchol
 t_a[72+w+0]=0.0f; t_a[72+w+1]=0.0f; // 1. vrchol
 t_a[72+w+2]=1.0f; t_a[72+w+3]=1.0f; // 2. vrchol
 t_a[72+w+4]=0.0f; t_a[72+w+5]=1.0f; // 3. vrchol
 TBN(e,q,w);
 q+=9; w+=6;

 v_a[e+q+0]=-5.0f; v_a[e+q+1]=0.0f;  v_a[e+q+2]=-5.0f; // 1. vrchol
 v_a[e+q+3]= 5.0f; v_a[e+q+4]=0.0f;  v_a[e+q+5]=-5.0f; // 2. vrchol
 v_a[e+q+6]= 5.0f; v_a[e+q+7]=10.0f; v_a[e+q+8]=-5.0f; // 3. vrchol
 c_a[e+q+0]=0.2f; c_a[e+q+1]=0.2f; c_a[e+q+2]=0.2f; // 1. vrchol
 c_a[e+q+3]=0.2f; c_a[e+q+4]=0.2f; c_a[e+q+5]=0.2f; // 2. vrchol
 c_a[e+q+6]=0.2f; c_a[e+q+7]=0.2f; c_a[e+q+8]=0.2f; // 3. vrchol
 t_a[72+w+0]=0.0f; t_a[72+w+1]=0.0f; // 1. vrchol
 t_a[72+w+2]=1.0f; t_a[72+w+3]=0.0f; // 2. vrchol
 t_a[72+w+4]=1.0f; t_a[72+w+5]=1.0f; // 3. vrchol
 TBN(e,q,w);
 q+=9; w+=6;

 v_a[e+q+0]=-5.0f; v_a[e+q+1]=0.0f; v_a[e+q+2]=-5.0f; // 1. vrchol
 v_a[e+q+3]= 5.0f; v_a[e+q+4]=10.0f; v_a[e+q+5]=-5.0f; // 2. vrchol
 v_a[e+q+6]=-5.0f; v_a[e+q+7]=10.0f; v_a[e+q+8]=-5.0f; // 3. vrchol
 c_a[e+q+0]=0.2f; c_a[e+q+1]=0.2f; c_a[e+q+2]=0.2f; // 1. vrchol
 c_a[e+q+3]=0.2f; c_a[e+q+4]=0.2f; c_a[e+q+5]=0.2f; // 2. vrchol
 c_a[e+q+6]=0.2f; c_a[e+q+7]=0.2f; c_a[e+q+8]=0.2f; // 3. vrchol
 t_a[72+w+0]=0.0f; t_a[72+w+1]=0.0f; // 1. vrchol
 t_a[72+w+2]=1.0f; t_a[72+w+3]=1.0f; // 2. vrchol
 t_a[72+w+4]=0.0f; t_a[72+w+5]=1.0f; // 3. vrchol
 TBN(e,q,w);
 q+=9; w+=6;

 objs.tris_num=e/3+q/3; // kocka+gula+valec+ihlan+plochy
 printf("pocet trojuholnikov: %i\n",objs.tris_num);

 // priprava objektov - kocka, gula, valec, ihlan, plochy
 objs.buffers_prepare();
 // nahratie udajov do zasobnikov
 objs.vertices->load(sizeof(v_a),v_a);
 objs.colors->load(sizeof(c_a),c_a);
 objs.tangents->load(sizeof(tan_a),tan_a);
 objs.binormals->load(sizeof(bin_a),bin_a);
 objs.normals->load(sizeof(nor_a),nor_a);
 objs.texcoords->load(sizeof(t_a),t_a);

#ifdef OGL20
 // vrcholy
 glEnableVertexAttribArray(0);                     // povolenie pola atributov
 objs.vertices->bind();                            // pripojenie buffra
 glVertexAttribPointer(0,3,GL_FLOAT,GL_FALSE,0,0); // ukazovatel na udaje
 // farby
 glEnableVertexAttribArray(1);
 objs.colors->bind();
 glVertexAttribPointer(1,3,GL_FLOAT,GL_FALSE,0,0);
 // tangenty
 glEnableVertexAttribArray(2);
 objs.tangents->bind();
 glVertexAttribPointer(2,3,GL_FLOAT,GL_FALSE,0,0);
 // binormaly
 glEnableVertexAttribArray(3);
 objs.binormals->bind();
 glVertexAttribPointer(3,3,GL_FLOAT,GL_FALSE,0,0);
 // normaly
 glEnableVertexAttribArray(4);
 objs.normals->bind();
 glVertexAttribPointer(4,3,GL_FLOAT,GL_FALSE,0,0);
 // texturovacie suradnice
 glEnableVertexAttribArray(8);
 objs.texcoords->bind();
 glVertexAttribPointer(8,2,GL_FLOAT,GL_FALSE,0,0);
#else
 // vrcholy
 glEnableVertexAttribArrayARB(0);
 objs.vertices->bind();
 glVertexAttribPointerARB(0,3,GL_FLOAT,GL_FALSE,0,0);
 // farby
 glEnableVertexAttribArrayARB(1);
 objs.colors->bind();
 glVertexAttribPointerARB(1,3,GL_FLOAT,GL_FALSE,0,0);
 // tangenty
 glEnableVertexAttribArrayARB(2);
 objs.tangents->bind();
 glVertexAttribPointerARB(2,3,GL_FLOAT,GL_FALSE,0,0);
 // binormaly
 glEnableVertexAttribArrayARB(3);
 objs.binormals->bind();
 glVertexAttribPointerARB(3,3,GL_FLOAT,GL_FALSE,0,0);
 // normaly
 glEnableVertexAttribArrayARB(4);
 objs.normals->bind();
 glVertexAttribPointerARB(4,3,GL_FLOAT,GL_FALSE,0,0);
 // texturovacie suradnice
 glEnableVertexAttribArrayARB(8);
 objs.texcoords->bind();
 glVertexAttribPointerARB(8,2,GL_FLOAT,GL_FALSE,0,0);
#endif
 // INFO: bez shaderov
/*
 glEnableClientState(GL_VERTEX_ARRAY);
 glVertexPointer(3,GL_FLOAT,0,v_a);
 glEnableClientState(GL_COLOR_ARRAY);
 glColorPointer(3,GL_FLOAT,0,c_a);
*/
}

// vykreslanie objektov - kocka, gula, valec, ihlan, plochy ****************
void CInterface::objects_draw(void)
{
 // vsetky objekty
 glDrawArrays(GL_TRIANGLES,0,objs.tris_num);
 // iba plochy
 //glDrawArrays(GL_TRIANGLES,(4824-36)/3,12);
}

// mys je/nie je na tlacidle ***********************************************
bool CInterface::on_button(float X,float Y)
{
 // pre vsetky tlacidla
 loopi(BUTNUM) {
  // ak je mys na tlacidle
  if (but[i].on_button(X,Y)) { but_id=i; return(true); }
 }
 // mys nie je na tlacidle
 return(false);
}

// zmena udajov tlacidiel **************************************************
void CInterface::button_update(float X)
{
 // zmena udajov konkretneho tlacidla
 but[but_id].update(X/200.0f);
 but_data=but[but_id].get_data();
 // zmena parametrov osvetlenia podla zmenenych udajov tlacidiel
 switch (but_id) {
  case 0: lsrcparam.ambient.x=but_data; break;
  case 1: lsrcparam.ambient.y=but_data; break;
  case 2: lsrcparam.ambient.z=but_data; break;
  case 3: lsrcparam.ambient.w=but_data; break;
  case 4: lsrcparam.diffuse.x=but_data; break;
  case 5: lsrcparam.diffuse.y=but_data; break;
  case 6: lsrcparam.diffuse.z=but_data; break;
  case 7: lsrcparam.diffuse.w=but_data; break;
  case 8: lsrcparam.specular.x=but_data; break;
  case 9: lsrcparam.specular.y=but_data; break;
  case 10: lsrcparam.specular.z=but_data; break;
  case 11: lsrcparam.specular.w=but_data; break;
  case 12: lsrcparam.position.x=but_data; break;
  case 13: lsrcparam.position.y=but_data; break;
  case 14: lsrcparam.position.z=but_data; break;
  case 15: lsrcparam.position.w=but_data; break;
  case 16: lsrcparam.constantAttenuation=but_data; break;
  case 17: lsrcparam.linearAttenuation=but_data; break;
  case 18: lsrcparam.quadraticAttenuation=but_data; break;
  case 19: lmodelparam.ambient.x=but_data; break;
  case 20: lmodelparam.ambient.y=but_data; break;
  case 21: lmodelparam.ambient.z=but_data; break;
  case 22: lmodelparam.ambient.w=but_data; break;
  case 23: mparam.ambient.x=but_data; break;
  case 24: mparam.ambient.y=but_data; break;
  case 25: mparam.ambient.z=but_data; break;
  case 26: mparam.ambient.w=but_data; break;
  case 27: mparam.diffuse.x=but_data; break;
  case 28: mparam.diffuse.y=but_data; break;
  case 29: mparam.diffuse.z=but_data; break;
  case 30: mparam.diffuse.w=but_data; break;
  case 31: mparam.specular.x=but_data; break;
  case 32: mparam.specular.y=but_data; break;
  case 33: mparam.specular.z=but_data; break;
  case 34: mparam.specular.w=but_data; break;
  case 35: mparam.emission.x=but_data; break;
  case 36: mparam.emission.y=but_data; break;
  case 37: mparam.emission.z=but_data; break;
  case 38: mparam.emission.w=but_data; break;
  case 39: mparam.shininess=but_data; break;
  default: break;
 }

 // aktualizacia parametrov osvetlenia
 update_lighting_params();
}
