#ifndef _INTERFACE_H_
#define _INTERFACE_H_

// pole uplynutych ms
#define MSHISTORY 20

// pocet tlacidiel
#define BUTNUM 40

// deklaracia tried pre pracu s jednotlivymi modulmi
#include "common/avatar.h"
#include "common/button.h"

// OpenGL zasobnik - buffer
class GLbuf
{
public:
 // konstruktor
 GLbuf(GLenum T=GL_ARRAY_BUFFER) {
#ifdef OGL20
  glGenBuffers(1,&buf); // vygenerovanie 1 zasobnika
#else
  glGenBuffersARB(1,&buf);
#endif
  target=T;             // ciel, standardne GL_ARRAY_BUFFER
 }
 // destruktor
 ~GLbuf() {
#ifdef OGL20
  glDeleteBuffers(1,&buf);
#else
  glDeleteBuffersARB(1,&buf);
#endif
 }
 // nahratie udajov
 void load(size_t SIZE,void *DATA=NULL,GLenum USAGE=GL_STATIC_DRAW) {
#ifdef OGL20
  glBindBuffer(target,buf);             // zasobnik, s ktorym sa bude pracovat
  glBufferData(target,SIZE,DATA,USAGE); // nahratie udajov do zasobnika (moze byt aj NULL)
#else
  glBindBufferARB(target,buf);
  glBufferDataARB(target,SIZE,DATA,USAGE);
#endif
 }
 // zasobnik, s ktorym sa bude pracovat
 void bind(void) {
#ifdef OGL20
  glBindBuffer(target,buf);
#else
  glBindBufferARB(target,buf);
#endif
 }
private:
 GLuint buf;    // identifikator zasobnika
 GLenum target; // ciel
};

// OpenGL objekt - kocka, gula, valec, ihlan, plochy
class GLobj
{
public:
 // konstruktor
 GLobj() {
  vertices=NULL; colors=NULL;
  tangents=NULL; binormals=NULL; normals=NULL;
  texcoords=NULL;
  tris_num=0;
 }
 // destruktor
 ~GLobj() {
   DELETEP(vertices); DELETEP(colors);
   DELETEP(tangents); DELETEP(binormals); DELETEP(normals);
   DELETEP(texcoords);
  }

 // vytvorenie jednotlivych buffrov
 int buffers_prepare(void) {
  vertices=new GLbuf; colors=new GLbuf;                       // vrcholy, farby
  tangents=new GLbuf; binormals=new GLbuf; normals=new GLbuf; // tangenty, binormaly, normaly
  texcoords=new GLbuf;                                        // texturovacie suradnice
  if (vertices==NULL || colors==NULL ||
      tangents==NULL || binormals==NULL || normals==NULL ||
      texcoords==NULL) {
   printf("Nemozno vytvorit OpenGL zasobniky!\n"); return(1);
  }
  return(0);
 }

 GLbuf *vertices,*colors;             // vrcholy, farby
 GLbuf *tangents,*binormals,*normals; // tangenty, binormaly, normaly
 GLbuf *texcoords;                    // texturovacie suradnice

 GLuint tris_num; // pocet trojuholnikov
};

// parametre svetelneho zdroja
struct LightSourceParam {
 vec4 ambient;
 vec4 diffuse;
 vec4 specular;
 vec4 position;      // w=0 - smerove (smeruje do 0,0,0), w=1 - bodove
 vec4 halfVector;
 vec3 spotDirection;
 float spotExponent; // <0.0f;128.0f>
 float spotCutoff;   // <0.0f;90.0f>, 180.0f
 float spotCosCutoff;
 float constantAttenuation;
 float linearAttenuation;
 float quadraticAttenuation;
};

// parametre osvetlovacieho modelu
struct LightModelParam {
 vec4 ambient;
};

// svetelne parametre materialu
struct MaterialParam {
 vec4 ambient;
 vec4 diffuse;
 vec4 specular;
 vec4 emission;
 float shininess;
};

// trieda premennych a funkcii pre pracu s OpenGL
class CInterface {
public:
 CInterface();  // konstruktor
 ~CInterface(); // destruktor

 CAvatar avatar; // instancia triedy CAvatar - praca s kamerou

 // inicializacia OpenGL - nastavenie parametrov OpenGL sceny
 int OGL_initialize(void);

 void resettimer(void);  // nastartovanie casovaca
 void updatetimer(void); // aktualizacia casovaca

 void OGL_idle(void); // casovo zavisla uprava objektov, resp. sceny
 void OGL_draw(void); // vykreslenie OpenGL sceny

 // mys je/nie je na tlacidle
 bool on_button(float X,float Y);
 // zmena udajov tlacidla
 void button_update(float X);
private:
 // aktualny a povodny casovy okamih (ms), pocet uplynutych milisekund
 GLuint actTime,oldTime,millis;
 // pomocne premenne
 GLint fpsdelay,fpserror;
 // uplynute ms
 GLuint mspos,mstotal,mshistory[MSHISTORY];
 // pocet snimkov za sekundu, minimalny a maximalny pocet snimkov za sekundu
 GLuint actfps,minfps,maxfps;

 // osvetlenie
 LightSourceParam lsrcparam;
 LightModelParam lmodelparam;
 MaterialParam mparam;

 // velkost zameriavacieho kriza
 GLfloat crosshairSize;

 CButton but[BUTNUM]; // tlacidla menu
 int but_id;          // index aktivneho tlacidla
 float but_data;      // udaj tlacidla

 GLuint vao; // Vertex Array Object

 GLobj objs; // kocka, gula, valec, ihlan, plochy

 mat4x4 mvmat; // pre docasne ulozenie modelview matice
 vec3 s,t,v[4]; // pomocne premenne

 // aktualny pocet fps, minimalny a maximalny pocet fps
 void getfps(GLuint &ACT,GLuint &MIN,GLuint &MAX);

 // aktualizacia parametrov osvetlenia
 void update_lighting_params(void);

 // vykreslenie head-up display
 void drawhud(void);

 // vypocet TBN vektorov
 void TBN(int E,int Q,int W);
 // priprava objektov - kocka, gula, valec, ihlan, plochy
 void objects_prepare(void);
 // vykreslenie objektov - kocka, gula, valec, ihlan, plochy
 void objects_draw(void);
};

#endif
