#version 130 // GLSL verzia

uniform sampler2D base_tex_unit; // zakladna textura

in vec4 pos; // poloha vrcholu v EYE space
in vec3 nor;
in vec3 dir_to_light;
in float dist;
in vec4 ambient,diffuse;

in vec2 fragment_pos; // poloha fragmentu v OBJECT space

const vec2 brickSize=vec2(0.6,0.3);          // velkost tehly
const vec2 mortarPos=vec2(0.9,0.9);          // poloha malty v ramci tehly
const vec3 brickColor=vec3(0.8,0.3,0.2);     // farba tehly
const vec3 mortarColor=vec3(0.75,0.76,0.74); // farba malty

void main(void)
{
 vec4 color,amb,dif=vec4(0.0);
 vec3 N,L;
 float NdotL,att;

 vec2 fragPos,colorSelector;
 // podiel polohy fragmentu a velkosti tehly
 fragPos=fragment_pos/brickSize;
 // posun tehiel na neparnych riadkoch o 1/2 sirky doprava
 if (fract(fragPos.y*0.5)>0.5) fragPos.x+=0.5;
 // poloha fragmentu v ramci tehly
 fragPos=fract(fragPos);
 // poloha fragmentu voci polohe malty
 colorSelector=step(fragPos,mortarPos);
 // farba v zavislosti od polohy fragmentu v ramci tehly
 color.xyz=mix(mortarColor,brickColor,colorSelector.x*colorSelector.y);
 color.w=1.0;

 // ambient
 amb=color;

 // utlm
 att=1.0/(gl_LightSource[0].constantAttenuation+
          gl_LightSource[0].linearAttenuation*dist+
          gl_LightSource[0].quadraticAttenuation*dist*dist);

 // normalizacia interpolovanych udajov
 N=normalize(nor);
 L=normalize(dir_to_light);

 NdotL=max(dot(N,L),0.0);
 if (NdotL>0.0) {
  // diffuse
  dif=NdotL*diffuse;
 }

 // vysledna farba
 gl_FragColor=att*(amb+dif);
}