#version 130 // GLSL verzia

uniform sampler2D base_tex_unit; // zakladna textura

in vec4 pos; // poloha vrcholu v EYE space
in vec3 nor;
in vec2 uv;
in vec3 dir_to_light,dir_to_eye;
in float dist;
in vec4 ambient,diffuse,specular;

void main(void)
{
 vec4 color,amb,dif=vec4(0.0),spe=vec4(0.0);
 vec3 N,L,E,HV;
 float NdotL,att;

 // farba z textury
 color=texture2D(base_tex_unit,uv);

 // ambient
 amb=color*ambient;

 // utlm
 att=1.0/(gl_LightSource[0].constantAttenuation+
          gl_LightSource[0].linearAttenuation*dist+
          gl_LightSource[0].quadraticAttenuation*dist*dist);

 // normalizacia interpolovanych udajov
 N=normalize(nor);
 L=normalize(dir_to_light);

 NdotL=max(dot(N,L),0.0);
 if (NdotL>0.0) {
  // diffuse
  dif=NdotL*diffuse;

  // specular
  E=normalize(dir_to_eye);
  HV=normalize(-reflect(L,N)); // half vector
  spe=pow(max(dot(E,HV),0.0),gl_FrontMaterial.shininess)*specular;
 }

 // vysledna farba
 gl_FragColor=att*(amb+dif+spe);
}