from scapy.all import *  # Scapy
from scapy.layers.dns import DNS, DNSQR
from scapy.layers.inet import IP, TCP, ICMP, UDP
from scapy.layers.l2 import Ether, ARP
import signal
import sys

import dash  # Dash framework
from dash import html
from dash.dependencies import Input, Output, State
from dash import dash_table

import pandas as pd  # Pandas

PORTSVC = {
    7: "ECHO protokol",
    13: "DAYTIME protokol",
    20: "FTP prenos dát",
    21: "FTP správa",
    22: "SSH protokol",
    23: "Telnet protokol",
    25: "SMTP protokol",
    37: "TIME protokol",
    42: "WINS služba",
    43: "WHOIS protokol",
    52: "XNS Time protokol",
    53: "DNS služba",
    56: "RAP protokol",
    67: "DHCP protokol",
    68: "DHCP protokol",
    69: "TFTP protokol",
    79: "FINGER protokol",
    80: "HTTP protokol",
    88: "Kerberos autentifikácia",
    107: "Vzdialená Telnet služba",
    109: "POP2 protokol",
    110: "POP3 protokol",
    115: "SFTP protokol",
    118: "SQL služby",
    123: "NTP protokol",
    137: "NetBIOS Name služba",
    138: "NetBIOS Datagram služba",
    139: "NetBIOS Session služba",
    143: "IMAP protokol",
    152: "BFTP Background File Transfer Program",
    156: "SQL služba",
    161: "SNMP protokol",
    162: "SNMP protokol",
    170: "Network PostScript",
    194: "IRC služba",
    220: "IMAPv3",
    280: "HTTP manažment",
    389: "LDAP protokol",
    443: "HTTPS protokol",
    445: "Server Message Block (SMB)",
    464: "Kerberos nastavenie/zmena hesla",
    465: "SMTP cez TLS/SSL",
    500: "ISAKMP/IKE",
    520: "RIP protokol",
    530: "RPC protokol",
    543: "klogin Kerberos login",
    544: "kshell Kerberos shell",
    546: "DHCPv6 klient",
    547: "DHCPv6 server",
    554: "RTSP protokol",
    631: "CUPS služba",
    636: "LDAP cez TLS/SSL",
    901: "Samba WAT",
    903: "VMware konzola",
    989: "FTP data cez TLS/SSL",
    990: "FTP kontrola cez TLS/SSL",
    995: "POP3 cez TLS/SSL",
    3306: "MySQL databáza",
    5432: "PostgreSQL databáza",
    8080: "HTTP protokol",
    8443: "HTTPS protokol"
}

# porty, ktore sa budu skenovat
ports_to_scan = [20, 21, 22, 23, 25, 53, 67, 68, 80, 110, 143, 443, 8080, 8443]

# inicializacia Pandas DataFrame, index=id
answers_data = pd.DataFrame(columns=['id', 'rowid', 'scanTYPE', 'dstMAC', 'dstIP'])
answers_data.set_index('id', inplace=True)
selected_data = pd.DataFrame(columns=['id', 'rowid', 'dstPORT', 'dstSVC'])
selected_data.set_index('id', inplace=True)

sel_answer = 0  # id vybranej odozvy


# SKENUJ SIET
def MAC_IP_scan(host):
    # id prijatych odoziev
    m_id = 1
    # zmazanie DataFramov
    answers_data.drop(answers_data.index, inplace=True)
    selected_data.drop(selected_data.index, inplace=True)

    # ARP scan
    # sendrcv() vrati 2x List - ans = SndRcvList, unans = PacketList
    # srp - send Ethernet frame na 2. vrstve OSI modelu - Ethernet header / ARP header
    ans, unans = srp(Ether(dst="ff:ff:ff:ff:ff:ff") / ARP(pdst=host), timeout=3)
    # print('ans: ', ans.summary())
    # print('unans:  ', unans.summary())
    for s, r in ans:
        # ans = SndRcvList = send, received frames
        # print('s: ', s)
        # print('r:  ', r)
        answers_data.loc[m_id] = (m_id, 'ARP', r.hwsrc, r.psrc)
        m_id += 1

    # ICMP Ping scan
    # ans, unans = sr(IP(dst=host) / ICMP(), timeout=3)
    # for s, r in ans:
    #    answers_data.loc[m_id] = (m_id, 'ICMP Ping', '-', r.sprintf('%IP.src%'))
    #    m_id += 1

    # TCP Ping
    # ans, unans = sr(IP(dst=host) / TCP(dport=80, flags="S"))
    # for s, r in ans:
    #    answers_data.loc[m_id] = (m_id, 'TCP Ping', '-', r.sprintf('%IP.src%'))
    #    m_id += 1

    # UDP Ping
    # ans, unans = sr(IP(dst=host) / UDP(dport=0))
    # for s, r in ans:
    #    answers_data.loc[m_id] = (m_id, 'UDP Ping', '-', r.sprintf('%IP.src%'))
    #    m_id += 1


# SKENUJ PORTY VYBRANEJ IP ADRESY
def PORT_scan(host):
    # id prijatych odoziev
    m_id = 1
    # zmazanie DataFramu
    selected_data.drop(selected_data.index, inplace=True)

    # sken otvorenych portov
    # sr - send Network packet na 3. vrstve OSI modelu - IP header / TCP header
    ans, unans = sr(IP(dst=host) / TCP(sport=11111, dport=ports_to_scan, flags='S'), timeout=3, verbose=1)
    # print(ans.summary())
    for s, r in ans:
        # ak ma prijaty paket TCP vrstvu
        if r.haslayer(TCP):
            # ak srcPORT == dstPORT a TCP flags == SYN, ACK
            if s[TCP].dport == r[TCP].sport and r[TCP].flags == 'SA':
                try:
                    if r[TCP].sport in PORTSVC.keys():
                        svc = PORTSVC[r[TCP].sport]
                    else:
                        svc = str(r[TCP].sport)
                except AttributeError:
                    svc = 'Neznáma služba'
                selected_data.loc[m_id] = (m_id, r[TCP].sport, svc)
                m_id += 1
    # sken existencie DNS servera
    # sr - send Network packet na 3. vrstve OSI modelu - IP header / UDP header / DNS header
    ans, unans = sr(IP(dst=host) / UDP(dport=53) / DNS(rd=1, qd=DNSQR(qname='softengine.sk')), timeout=3, verbose=0)
    if ans and ans[UDP]:
        selected_data.loc[m_id] = (m_id, 53, 'DNS server')
        m_id += 1


myMAC = get_if_hwaddr(conf.iface)  # moja MAC adresa
myIP = get_if_addr(conf.iface)  # moja IP adresa

# inicializacia Dash aplikacie
app = dash.Dash(__name__)

# definicia Dash layoutu
app.layout = html.Div(
    # 2 riadky
    children=[
        html.Div(className='row',  # 1. riadok ----------------------------------------------------------------------
                 children=[  # 1. stlpec
                     html.H1('Sieťový skener v.1'),
                     html.Table(
                         style={'marginLeft': '20px', 'marginBottom': '20px'},
                         children=[
                             html.Tr(
                                 children=[
                                     html.Td(
                                         style={'text-align': 'center', 'border-bottom': 'none',
                                                'border-right': '1px solid'},
                                         children=[html.Div('Moja MAC adresa je:'),
                                                   html.Div(className='ADResa', children=[myMAC])]),
                                     html.Td(
                                         style={'text-align': 'center', 'border-bottom': 'none',
                                                'border-right': '1px solid'},
                                         children=[html.Div('Moja IP adresa je:'),
                                                   html.Div(className='ADResa', children=[myIP])]),
                                     html.Td(
                                         style={'text-align': 'center', 'border-bottom': 'none'},
                                         children=[html.Div('Skenuje sa sieť:'),
                                                   html.Div(className='ADResa', children=[myIP + '/24'])])
                                 ]
                             )
                         ]
                     )
                 ]
                 ),
        html.Div(className='row',  # 2. riadok ----------------------------------------------------------------------
                 children=[  # 1. stlpec
                     html.Div(className='five columns', style={'margin-left': 20},
                              children=[  # 1. riadok
                                  html.Div(children=[html.Button(id='skenuj', children=['SKENUJ SIET'],
                                                                 style={'margin-bottom': '10px',
                                                                        'background-color': '#333333',
                                                                        'color': '#ffffff'}
                                                                 )
                                                     ]
                                           ),
                                  html.Div(children=[dash_table.DataTable(
                                      id='table1',
                                      fixed_rows={'headers': True, 'data': 0},
                                      columns=[{'id': 'rowid', 'name': 'ID'},
                                               {'id': 'scanTYPE', 'name': 'Typ skenu'},
                                               {'id': 'dstMAC', 'name': 'MAC adresa'},
                                               {'id': 'dstIP', 'name': 'IP adresa'}],
                                      style_table={'border': 'grey solid',
                                                   'width': 800, 'height': 240},
                                      style_header={'color': 'lightgrey',
                                                    'backgroundColor': 'rgb(30,30,30)',
                                                    'fontWeight': 'bold'},
                                      style_cell={'color': 'white',
                                                  'backgroundColor': 'rgb(50,50,50)',
                                                  'border': '0px solid',
                                                  'font-family': 'Open Sans Semi',
                                                  'font-size': '0.8em',
                                                  'textAlign': 'center',
                                                  'min-width': '70px'},
                                      style_as_list_view=True,
                                      style_data_conditional=[{'if': {'row_index': 'odd'},
                                                               'backgroundColor': 'rgb(70,70,70)'}],
                                      page_action='none')]
                                  ),
                                  html.Div(className='ADResa', id='selected_answer_text', style={'margin-top': '10px'}),
                                  html.Div(
                                      children=[html.Button(id='detaily', children=['SKENUJ PORTY VYBRANEJ IP ADRESY'],
                                                            style={'margin-top': '5px',
                                                                   'margin-bottom': '10px',
                                                                   'background-color': '#555555',
                                                                   'color': '#ffffff'}
                                                            )
                                                ]
                                  ),
                                  html.Div(style={'margin-bottom': '10px'},
                                           children=[dash_table.DataTable(
                                               id='table2',
                                               fixed_rows={'headers': True, 'data': 0},
                                               columns=[{'id': 'rowid', 'name': 'ID'},
                                                        {'id': 'dstPORT', 'name': 'Port'},
                                                        {'id': 'dstSVC', 'name': 'Služba'}],
                                               style_table={'border': 'grey solid',
                                                            'width': 800, 'height': 240},
                                               style_header={'color': 'lightgrey',
                                                             'backgroundColor': 'rgb(30,30,30)',
                                                             'fontWeight': 'bold'},
                                               style_cell={'color': 'white',
                                                           'backgroundColor': 'rgb(50,50,50)',
                                                           'border': '0px solid',
                                                           'font-family': 'Open Sans Semi',
                                                           'font-size': '0.8em',
                                                           'textAlign': 'center',
                                                           'min-width': '70px'},
                                               style_as_list_view=True,
                                               style_data_conditional=[{'if': {'row_index': 'odd'},
                                                                        'backgroundColor': 'rgb(70,70,70)'}])]
                                           )
                              ]
                              )
                 ]
                 )
    ]
)


# Callback funkcia pre tabulku 1 - "Obnovenie"
@app.callback([Output('table1', 'data'),
              Output('table1', 'active_cell'),
              Output('table2', 'data', allow_duplicate=True)],
              Input('skenuj', 'n_clicks'), prevent_initial_call=True)
def update_table1(n_c):
    # id vybranej odozvy
    global sel_answer

    # SKENUJ SIET
    MAC_IP_scan(myIP+'/24')

    # nie je vybrana ziadna odozva
    sel_answer = 0
    # zmazanie DataFramu
    selected_data.drop(selected_data.index, inplace=True)
    n = {'rowid': '-', 'dstPORT': '-', 'dstSVC': '-'}, {'rowid': '-', 'dstPORT': '-', 'dstSVC': '-'}

    return [answers_data.to_dict('records'), None, n]


# Callback funkcia pre tabulku 1 - "Vyber bunky - riadku"
@app.callback(Output('selected_answer_text', 'children'),
              [Input('table1', 'active_cell')],
              [State('table1', 'data')], prevent_initial_call=True)
def select_table1_row(active_cell, data):
    # id vybranej odozvy
    global sel_answer

    # ak bola vybrana odozva
    if active_cell:
        row = active_cell['row']
        sel_answer = data[row]['rowid']
        return html.P(f'Bola vybraná odozva ID: {sel_answer}' + ', IP adresa:' + data[row]['dstIP'])

    return html.P('Nie je vybraná žiadna odozva')


# Callback funkcia pre tabulku 2 - "Detaily"
@app.callback([Output('table2', 'data')],
              [Input('detaily', 'n_clicks')], prevent_initial_call=True)
def update_table2(n_c):
    # id vybranej odozvy
    global sel_answer

    # ak bola vybrana nejaka odozva
    if sel_answer != 0:
        # SKENUJ PORTY VYBRANEJ IP ADRESY
        PORT_scan(answers_data.loc[sel_answer][3])
        # ak bol najdeny nejaky otvoreny port
        if not selected_data.empty:
            return [selected_data.to_dict('records')]

    n = {'rowid': '-', 'dstPORT': '-', 'dstSVC': '-'}, {'rowid': '-', 'dstPORT': '-', 'dstSVC': '-'}
    return [n]


# ukoncenie programu po stlaceni Ctrl+C
def CtrlC(sig, frame):
    print("Koniec...\n")
    sys.exit(0)


if __name__ == "__main__":
    # nastavenie Signal handleru
    signal.signal(signal.SIGINT, CtrlC)
    # spustenie Dash aplikacie - main sa z dovodu debuggingu spusta 2x
    app.run_server(debug=True, port=8051)
