from dash import html, dcc
from dash.dependencies import Input, Output

import signal
import sys

# Dash aplikacia
from app import my_app

# navigacna lista
from components import navbar

# jednotlive stranky
from pages import page1, page2, page3, page4, page5, page6

# vzhlad stranky index
my_app.layout = html.Div([
    dcc.Location(id='url', refresh=False),
    navbar.my_navbar(),
    html.Div(id='page-content', children=[])
])


# callback funkcia pre zobrazenie jednotlivych stranok
@my_app.callback(Output('page-content', 'children'),
                 [Input('url', 'pathname')])
def display_page(pathname):
    if pathname == '/page1':
        return page1.layout
    if pathname == '/page2':
        return page2.layout
    if pathname == '/page3':
        return page3.layout
    if pathname == '/page4':
        return page4.layout
    if pathname == '/page5':
        return page5.layout
    if pathname == '/page6':
        return page6.layout
    else:  # neznama stranka
        return page1.layout


# ukoncenie aplikacie po stlaceni Ctrl+C
def CtrlC(sig, frame):
    print("Koniec...\n")
    sys.exit(0)


# spustenie Dash aplikacie na adrese localhost:8051
if __name__ == '__main__':
    # nastavenie Signal handleru
    signal.signal(signal.SIGINT, CtrlC)
    # spustenie Dash aplikacie - index sa z dovodu debuggingu spusta 2x
    my_app.run_server(debug=True, port=8051)
