from dash import html, callback, dcc
import dash_bootstrap_components as dbc
from dash.dependencies import Input, Output
from dash import dash_table

from scapy.all import *  # Scapy
from scapy.layers.inet import IP
from scapy.layers.dhcp import DHCP, BOOTP
from scapy.layers.l2 import Ether

import pandas as pd  # Pandas

pkt_data1 = pd.DataFrame(columns=['id', 'pktID', 'srcHostname', 'srcMAC', 'pktType'])
pkt_data1.set_index("id", inplace=True)
pkt_data2 = pd.DataFrame(columns=['id', 'pktID', 'serverIP', 'serverMAC', 'leasedIP', 'pktType'])
pkt_data2.set_index("id", inplace=True)

myMAC = get_if_hwaddr(conf.iface)  # moja MAC adresa
myIP = get_if_addr(conf.iface)  # moja IP adresa


# Scapy Sniffer
class DHCPSnifferClass(Thread):
    def __init__(self, interface="wlp1s0"):
        super().__init__()

        self.iface = interface  # vybrane rozhranie
        self.stop_sniffer = Event()  # pre spravne ukoncenie vlakna
        self.pkt_id1 = 0  # id prijateho paketu - request
        self.pkt_id2 = 0  # id prijateho paketu - ack

    # spustenie funkcie pkt_recv v samostatnom vlakne
    def run(self):
        sniff(iface=self.iface, filter="udp and (port 67 or 68)", prn=self.pkt_recv,
              stop_filter=self.should_stop_sniffer)

    # ukoncenie vlakna
    def join(self, timeout=None):
        self.stop_sniffer.set()
        super().join(timeout)

    # spravne ukoncenie vlakna
    def should_stop_sniffer(self, pkt):
        return self.stop_sniffer.is_set()

    def pkt_recv(self, pkt):
        if self.pkt_id1 > 500:  # ak bolo prijatych viac ako 500 paketov, DataFrame sa vymaze
            pkt_data1.drop(pkt_data1.index, inplace=True)
            self.pkt_id1 = 0
        if self.pkt_id2 > 500:  # ak bolo prijatych viac ako 500 paketov, DataFrame sa vymaze
            pkt_data2.drop(pkt_data2.index, inplace=True)
            self.pkt_id2 = 0

        # DHCP Request
        if DHCP in pkt and pkt[DHCP].options[0][1] == 3:
            # vyber hostname z DHCPoptions
            hostname = ''
            for i in pkt[DHCP].options:
                if i[0] == 'hostname':
                    # hostname je binarny retazec, tzn. je ho nutne dekodovat na unicode retazec
                    hostname = i[1].decode()

            # ulozenie udajov do DataFrame
            pkt_data1.loc[self.pkt_id1] = (self.pkt_id1, hostname, pkt[Ether].src, 'DHCP Request')
            self.pkt_id1 += 1  # boli pridane udaje o pakete
        # DHCP Ack
        elif DHCP in pkt and pkt[DHCP].options[0][1] == 5:
            # ulozenie IP, MAC adresy servera a zapozicanej IP do DataFrame
            pkt_data2.loc[self.pkt_id2] = (self.pkt_id2, pkt[IP].src, pkt[Ether].src, pkt[BOOTP].yiaddr, 'DHCP Ack')
            self.pkt_id2 += 1  # boli pridane udaje o pakete
        else:
            print('Iny typ DHCP paketu...')
            print(pkt.summary())
            print(ls(pkt))

        return

    def get_pkt_id1(self):
        return self.pkt_id1

    def get_pkt_id2(self):
        return self.pkt_id2


my_dhcp_sniffer = DHCPSnifferClass()  # objekt triedy DHCPSnifferClass
my_dhcp_sniffer_running = 0  # vlakno je / nie je spustene
my_dhcp_sniffer_progress = 0  # vizualne zobrazenie priebehu skenu

# vzhlad stranky
layout = dbc.Container([
    dbc.Row([
        html.H1('Sken 2 - DHCP sken')
    ]),
    dbc.Row([
        html.Table(
            style={'marginBottom': '20px'},
            children=[
                html.Tr(
                    children=[
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja MAC adresa je:'),
                                      html.Div(className='ADResa', children=[myMAC])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja IP adresa je:'),
                                      html.Div(className='ADResa', children=[myIP])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none', 'width': '33%'},
                            children=[html.Div('Skenuje sa sieť:'),
                                      html.Div(className='ADResa', children=[myIP + '/24'])])
                    ]
                )
            ]
        )
    ]),
    dbc.Row([
        html.Div(children=[html.Button(id='page2skenuj',
                                       children=['SKEN - START'],
                                       style={'margin-bottom': '10px',
                                              'background-color': '#333333',
                                              'color': '#ffffff'}
                                       ),
                           dcc.Input(id='page2pomocka', value='0', style={'display': 'none'}),
                           html.Div(children=[dbc.Progress(id='page2progbar', value=0, color='#1eaedb',
                                                           style={'height': '10px', 'margin-bottom': '10px'}),
                                              dcc.Interval(id='page2progbar-interval', n_intervals=0, interval=1000)])
                           ]),
        html.Div(children=[dash_table.DataTable(
            id='page2table1',
            fixed_rows={'headers': True, 'data': 0},
            columns=[{'id': 'pktID', 'name': 'ID'},
                     {'id': 'srcHostname', 'name': 'Žiadateľ Hostname'},
                     {'id': 'srcMAC', 'name': 'Žiadateľ MAC'},
                     {'id': 'pktType', 'name': 'Typ DHCP paketu'}],
            style_table={'border': 'grey solid', 'height': 300, 'margin-bottom': '10px'},
            style_header={'color': 'lightgrey',
                          'backgroundColor': 'rgb(30,30,30)',
                          'fontWeight': 'bold'},
            style_cell={'color': 'white',
                        'backgroundColor': 'rgb(50,50,50)',
                        'border': '0px solid',
                        'font-size': '1.2em',
                        'textAlign': 'center',
                        'min-width': '70px'},
            style_as_list_view=True,
            style_data_conditional=[{'if': {'row_index': 'odd'},
                                     'backgroundColor': 'rgb(70,70,70)'}],
            page_action='none'),
            dcc.Interval(
                id='page2table1_interval',
                interval=5000,  # aktualizuje n_intervals kazdych 5s
                n_intervals=0
            )
        ]),
        html.Div(children=[dash_table.DataTable(
            id='page2table2',
            fixed_rows={'headers': True, 'data': 0},
            columns=[{'id': 'pktID', 'name': 'ID'},
                     {'id': 'serverIP', 'name': 'Server IP'},
                     {'id': 'serverMAC', 'name': 'Server MAC'},
                     {'id': 'leasedIP', 'name': 'Zapožičaná IP'},
                     {'id': 'pktType', 'name': 'Typ DHCP paketu'}],
            style_table={'border': 'grey solid', 'height': 300},
            style_header={'color': 'lightgrey',
                          'backgroundColor': 'rgb(30,30,30)',
                          'fontWeight': 'bold'},
            style_cell={'color': 'white',
                        'backgroundColor': 'rgb(50,50,50)',
                        'border': '0px solid',
                        'font-size': '1.2em',
                        'textAlign': 'center',
                        'min-width': '70px'},
            style_as_list_view=True,
            style_data_conditional=[{'if': {'row_index': 'odd'},
                                     'backgroundColor': 'rgb(70,70,70)'}],
            page_action='none'),
            dcc.Interval(
                id='page2table2_interval',
                interval=5000,  # aktualizuje n_intervals kazdych 5s
                n_intervals=0
            )
        ])
    ])
])


# Callback funkcia pre tlacidlo - potrebna pre spravne zobrazovanie textu tlacidla pri vybere stranok
@callback(Output('page2skenuj', 'children'),
          [Input('page2pomocka', 'value')])
def update_page2skenuj(v):
    global my_dhcp_sniffer_running

    btn_text = 'SKEN - END'
    if my_dhcp_sniffer_running == 0:
        btn_text = 'SKEN - START'
    elif my_dhcp_sniffer_running == 1:
        btn_text = 'SKEN - STOP'

    return btn_text


# Callback funkcia pre tlacidlo - "SKEN - START/STOP/END"
@callback(Output('page2pomocka', 'value'),
          Input('page2skenuj', 'n_clicks'),
          prevent_initial_call=True)
def update_page2pomocka(n_c):
    global my_dhcp_sniffer
    global my_dhcp_sniffer_running

    btn_text = '2'
    if my_dhcp_sniffer_running == 0:
        print("Štart sliedenia...")
        my_dhcp_sniffer.start()  # spustenie sliedenia v samostatnom vlakne
        my_dhcp_sniffer_running = 1
        btn_text = '1'
    elif my_dhcp_sniffer_running == 1:
        print("Stop sliedenia...")
        my_dhcp_sniffer.join(3)  # ukoncenie vlakna
        my_dhcp_sniffer_running = 2
        btn_text = '2'

    return btn_text


# Callback funkcia pre tabulku 1 - aktualizacia kazdych 5s
@callback(Output('page2table1', 'data'),
          [Input('page2table1_interval', 'n_intervals')])
def update_page2table1(n):
    # print(pkt_data.to_dict('records'))
    return pkt_data1.to_dict('records')


# Callback funkcia pre tabulku 2 - aktualizacia kazdych 5s
@callback(Output('page2table2', 'data'),
          [Input('page2table2_interval', 'n_intervals')])
def update_page2table2(n):
    # print(pkt_data.to_dict('records'))
    return pkt_data2.to_dict('records')


# Callback funkcia pre progress bar - aktualizacia kazdu 1s
@callback(Output('page2progbar', 'value'),
          [Input('page2progbar-interval', 'n_intervals')])
def update_page2progress(n):
    global my_dhcp_sniffer_running
    global my_dhcp_sniffer_progress

    if my_dhcp_sniffer_running == 1:
        my_dhcp_sniffer_progress += 1
        if my_dhcp_sniffer_progress > 100:
            my_dhcp_sniffer_progress = 0

    return my_dhcp_sniffer_progress
