from dash import html, callback, dcc
import dash_bootstrap_components as dbc
from dash.dependencies import Input, Output
from dash import dash_table

from scapy.all import *  # Scapy

import pandas as pd  # Pandas

import dns
import dns.resolver
import socket

myMAC = get_if_hwaddr(conf.iface)  # moja MAC adresa
myIP = get_if_addr(conf.iface)  # moja IP adresa


# trieda DNS Sniffer
class DNSSnifferClass(Thread):
    def __init__(self, interface="eno1"):  # zmenit podla aktualneho interface !!!
        super().__init__()

        self.iface = interface  # vybrane rozhranie
        self.dns_data = pd.DataFrame(columns=['id', 'DNSid', 'subdomain', 'IPs'])
        self.dns_data.set_index("id", inplace=True)
        self.dns_id = 0  # id zaznamu

        self.res = dns.resolver.Resolver()  # objekt triedy DNS stub resolver
        self.res.nameservers = ['192.168.1.1', '8.8.8.8']  # zname DNS servre (pouzi nmcli)

        # skenovana domena
        self.domain = 'softengine.sk'
        # skenovane prefixy
        self.prefixes = 'host, dns, ns, ftp, www, web, mail, email, exchange, smtp, pop, imap, mx, mysql'
        self.subdomains = {}  # zoznam subdomen
        self.is_ans = 0  # prisla / neprisla odpoved na DNS poziadavky

    # najdenie nazvu domeny na zaklade IP adresy = Reverse DNS
    def DNSReverse(self, ip):
        d = self.domain
        try:
            ans = socket.gethostbyaddr(ip)  # vrati hostname a zoznam aliasov spojenych s danym hostname
            return [ans[0]] + ans[1]
        except socket.error:
            return []

    def DNSRequest(self, domain):
        IPs = []
        try:
            # vrati zoznam IP adries spojenych s nazvom subdomeny ako objekt triedy dns.resolver.Answer
            print('Skenujem subdomenu:', domain)
            ans = self.res.resolve(domain)
            if ans:
                self.is_ans = 1  # prisla odpoved na poziadavku
                IPs = [a.to_text() for a in ans]  # konverzia obsahu Answer objektu na text
                print('...ok...', IPs)
                # ak subdomena je v zozname
                if domain in self.subdomains:
                    self.subdomains[domain] = list(set(self.subdomains[domain] + IPs))  # zmena IPs danej subdomeny
                else:
                    print('pridavam', domain)
                    self.subdomains[domain] = IPs  # prvotne priradenie IPs k danej subdomene

                # pre kazdu IP adresu v ramci IPs najde nazov suvisiacej domeny = Reverse DNS
                for i in IPs:
                    rd = self.DNSReverse(i)
                    for d in rd:
                        # ak najdeny nazov suvisiacej domeny este nie je v zozname subdomen
                        if d not in self.subdomains:
                            self.subdomains[d] = [i]  # doplnenie suvisiacej subdomeny + IP adresy do zoznamu subdomen
                            self.DNSRequest(d)  # rekurzivne DNS Requesty pre suvisiacie subdomeny
                        else:
                            self.subdomains[d] = [i]  # doplnenie suvisiacej subdomeny + IP adresy do zoznamu subdomen

        except (dns.resolver.NXDOMAIN, dns.resolver.Timeout, dns.resolver.NoAnswer, dns.resolver.NoNameservers):
            print('...chyba...')
            return []
        return IPs

    def DNSScan(self, domena, prefixy):
        self.domain = domena  # skenovana domena
        print('Skenuje sa domena:', self.domain)
        subs_prefixes = prefixy.split(',')  # skenovane prefixy
        print('Skenuju sa prefixy:', subs_prefixes)

        # prisla / neprisla odpoved na DNS poziadavky
        self.is_ans = 0

        # DNS Request pre domenu
        self.DNSRequest(self.domain)

        # DNS Request pre konkretne subdomeny
        for p in subs_prefixes:
            self.DNSRequest(p + "." + self.domain)
            # doplnenie cisiel k prefixom nazvov subdomen
            # for i in range(0, 10):
            #    self.DNSRequest(p + str(i) + "." + self.domain)

        # ak prisla odpoved na DNS poziadavky
        if self.is_ans:
            # zmazanie DataFrame
            self.dns_data.drop(self.dns_data.index, inplace=True)
            self.dns_id = 0

            for d in self.subdomains:
                # spravne oddelenie IPs ciarkami
                iplist = ''
                iplist_len = len(self.subdomains[d])
                for i in self.subdomains[d]:
                    iplist += i
                    iplist_len -= 1
                    if iplist_len >= 1:
                        iplist += ', '
                # naplnenie DataFrame
                self.dns_data.loc[self.dns_id] = (self.dns_id, d, iplist)
                self.dns_id += 1  # bol pridany novy zaznam

            # usporiadanie zaznamov od najnovsieho po najstarsi
            self.dns_data = self.dns_data.sort_values(['DNSid'], ascending=False)

    def get_domain(self):
        return self.domain

    def get_prefixes(self):
        return self.prefixes

    def get_dns_data(self):
        return self.dns_data

    def get_dns_id(self):
        return self.dns_id


my_dns_sniffer = DNSSnifferClass()  # objekt triedy DNSSnifferClass
my_dns_sniffer_running = 0  # skener je / nie je spusteny
my_dns_sniffer_progress = 0  # vizualne zobrazenie priebehu skenu
my_btn_clicks = 0  # pocet kliknuti pri poslednom stlaceni tlacidla

# vzhlad stranky
layout = dbc.Container([
    dbc.Row([
        html.H1('Sken 3 - DNS sken')
    ]),
    dbc.Row([
        html.Table(
            style={'marginBottom': '20px'},
            children=[
                html.Tr(
                    children=[
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja MAC adresa je:'),
                                      html.Div(className='ADResa', children=[myMAC])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja IP adresa je:'),
                                      html.Div(className='ADResa', children=[myIP])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none', 'width': '33%'},
                            children=[html.Div('Skenuje sa sieť:'),
                                      html.Div(className='ADResa', children=[myIP + '/24'])])
                    ]
                )
            ]
        )
    ]),
    dbc.Row([
        html.Div(children=[html.Table(style={'marginBottom': '20px'},
                                      children=[
                                          html.Tr(children=[
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div('Skenuj doménu:')]),
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[dcc.Input(id='skenovana_domena',
                                                                          value=my_dns_sniffer.get_domain(),
                                                                          style={'width': 300})])
                                          ]
                                          ),
                                          html.Tr(children=[
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div('Skenuj prefixy:')]),
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[dcc.Input(id='skenovane_prefixy',
                                                                          value=my_dns_sniffer.get_prefixes(),
                                                                          style={'width': 800})])
                                          ]
                                          )
                                      ]),
                           html.Button(id='page3skenuj',
                                       n_clicks=0,
                                       children=['SKEN - START'],
                                       style={'margin-bottom': '10px',
                                              'background-color': '#333333',
                                              'color': '#ffffff'}
                                       ),
                           dcc.Input(id='page3pomocka', value='0', style={'display': 'none'}),
                           html.Div(children=[dbc.Progress(id='page3progbar', value=0, color='#1eaedb',
                                                           style={'height': '10px', 'margin-bottom': '10px'}),
                                              dcc.Interval(id='page3progbar-interval', n_intervals=0, interval=1000)])
                           ]),
        html.Div(children=[dash_table.DataTable(
            id='page3table1',
            fixed_rows={'headers': True, 'data': 0},
            columns=[{'id': 'DNSid', 'name': 'ID'},
                     {'id': 'subdomain', 'name': 'Subdoména'},
                     {'id': 'IPs', 'name': 'IP adresy'}],
            style_table={'border': 'grey solid', 'height': 600, 'margin-bottom': '10px'},
            style_header={'color': 'lightgrey',
                          'backgroundColor': 'rgb(30,30,30)',
                          'fontWeight': 'bold'},
            style_cell={'color': 'white',
                        'backgroundColor': 'rgb(50,50,50)',
                        'border': '0px solid',
                        'font-size': '1.2em',
                        'textAlign': 'center',
                        'min-width': '70px'},
            style_as_list_view=True,
            style_data_conditional=[{'if': {'row_index': 'odd'},
                                     'backgroundColor': 'rgb(70,70,70)'}],
            page_action='none'),
            dcc.Interval(
                id='page3table1_interval',
                interval=5000,  # aktualizuje n_intervals kazdych 5s
                n_intervals=0
            )
        ])
    ])
])


# Callback funkcia pre tlacidlo - "SKEN - START"
@callback(Output('page3pomocka', 'value'),
          [Input('page3skenuj', 'n_clicks'),
           Input('skenovana_domena', 'value'),
           Input('skenovane_prefixy', 'value')], prevent_initial_call=True)
def update_page3skenuj(n_c, domena, prefixy):
    global my_dns_sniffer_running
    global my_dns_sniffer_progress
    global my_dns_sniffer
    global my_btn_clicks

    # ak bolo stlacene tlacidlo
    if my_btn_clicks < n_c:
        my_btn_clicks = n_c
        # ak neprebieha sken
        if my_dns_sniffer_running == 0:
            print("Start...")
            my_dns_sniffer_running = 1
            my_dns_sniffer.DNSScan(domena, prefixy)
            print("Stop...")
            my_dns_sniffer_running = 0
            my_dns_sniffer_progress = 0

    return 1


# Callback funkcia pre tabulku 1 - aktualizacia kazdych 5s
@callback(Output('page3table1', 'data'),
          [Input('page3table1_interval', 'n_intervals')])
def update_page3table1(n):
    # print(pkt_data.to_dict('records'))
    return my_dns_sniffer.get_dns_data().to_dict('records')


# Callback funkcia pre progress bar - aktualizacia kazdu 1s
@callback(Output('page3progbar', 'value'),
          [Input('page3progbar-interval', 'n_intervals')])
def update_page3progress(n):
    global my_dns_sniffer_running
    global my_dns_sniffer_progress

    if my_dns_sniffer_running == 1:
        my_dns_sniffer_progress += 25
        if my_dns_sniffer_progress > 100:
            my_dns_sniffer_progress = 0

    return my_dns_sniffer_progress
