from dash import html, callback, dcc
import dash_bootstrap_components as dbc
from dash.dependencies import Input, Output
from dash import dash_table

from scapy.all import *  # Scapy

import pandas as pd  # Pandas

import telnetlib  # Telnet
import paramiko  # SSH

myMAC = get_if_hwaddr(conf.iface)  # moja MAC adresa
myIP = get_if_addr(conf.iface)  # moja IP adresa


# trieda DefaultCredidentials
class DefaultCredentialsClass(Thread):
    def __init__(self):
        super().__init__()

        self.host = '192.168.1.7'  # vybrane zariadenie
        self.TelnetPort = 23  # default Telnet port
        self.SSHPort = 22  # default SSH port
        self.do_telnet = 0  # ma sa testovat Telnet ?
        self.do_ssh = 0  # ma sa testovat SSH ?

        self.username = 'user'  # username = user
        self.pswd_file = 'data/default-passwords.txt'  # subor s heslami
        self.password = 'pswd'  # password = nacitane zo suboru pswd_file

        self.defcred_data = pd.DataFrame(columns=['id', 'DefCrdID', 'IP', 'PORT', 'USERNAME', 'PASSWORD'])
        self.defcred_data.set_index("id", inplace=True)
        self.defcred_id = 0  # id zaznamu

        self.stop_thread = Event()  # pre spravne ukoncenie vlakna

    # spustenie testovania v samostatnom vlakne
    def run(self):
        with open(self.pswd_file, 'r') as f:  # subor s heslami
            for line in f:
                if self.stop_thread.is_set():  # ak Event is set, ukoncenie vlakna
                    break
                pswd = line.strip()
                if pswd == '':  # ak je heslo '', pokracuje na dalsom hesle
                    continue
                self.password = pswd  # password = nacitane zo suboru pswd_file

                if self.do_telnet == 1:  # ak sa ma testovat Telnet
                    try:
                        tn = telnetlib.Telnet(self.host, self.TelnetPort, timeout=2)  # kontaktovanie zariadenia
                        tn.read_until(b'login: ')  # caka na zobrazenie login
                        tn.write((self.username + '\n').encode('utf-8'))  # vlozi username
                        tn.read_until(b'Password: ')  # caka na zobrazenie Password
                        tn.write((pswd + "\n").encode('utf-8'))  # vlozi password
                        result = tn.expect([b'Last login'])  # kontrola textu 'Last login' vo vystupe
                        if result[0] >= 0:
                            print("Telnet login OK %s:%s meno: %s, heslo: %s" % (
                                  self.host, self.TelnetPort, self.username, pswd))
                            # vlozenie noveho zaznamu do DataFrame
                            self.defcred_data.loc[self.defcred_id] = (self.defcred_id, self.host,
                                                                      str(self.TelnetPort) + ' (Telnet)',
                                                                      self.username, pswd)
                            self.defcred_id += 1  # bol pridany novy zaznam
                        tn.close()
                    except (TimeoutError, ConnectionRefusedError):
                        print("Telnet login neúspešný meno: %s, heslo: %s" % (self.username, pswd))

                    # chvilu pockaj
                    w = random.randint(5, 15)
                    print('Čakám %i s' % w)
                    time.sleep(w)

                if self.do_ssh == 1:  # ak sa ma testovat SSH
                    try:
                        ssh = paramiko.SSHClient()
                        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
                        # kontaktovanie zariadenia
                        ssh.connect(self.host, port=self.SSHPort, username=self.username, password=pswd)
                        ssh_session = ssh.get_transport().open_session()
                        # ak bola SSH session uspesne vytvorena
                        if ssh_session.active:
                            print("SSH login OK %s:%s meno: %s, heslo: %s" % (
                                  self.host, self.SSHPort, self.username, pswd))
                            # vlozenie noveho zaznamu do DataFrame
                            self.defcred_data.loc[self.defcred_id] = (self.defcred_id, self.host,
                                                                      str(self.SSHPort) + ' (SSH)',
                                                                      self.username, pswd)
                            self.defcred_id += 1  # bol pridany novy zaznam
                        ssh.close()
                    except (paramiko.ssh_exception.AuthenticationException,
                            paramiko.ssh_exception.NoValidConnectionsError,
                            paramiko.ssh_exception.SSHException):
                        print("SSH login neúspešný meno: %s, heslo: %s" % (self.username, pswd))

                    # chvilu pockaj
                    w = random.randint(5, 15)
                    print("Čakám %i s" % w)
                    time.sleep(w)

    # ukoncenie vlakna
    def join(self, timeout=None):
        self.stop_thread.set()
        super().join(timeout)

    def get_host(self):
        return self.host

    def get_username(self):
        return self.username

    def get_password(self):
        return self.password

    def get_defcred_data(self):
        return self.defcred_data

    def get_defcred_id(self):
        return self.defcred_id


my_defcred = DefaultCredentialsClass()  # objekt triedy DefaultCredentialsClass
my_defcred_running = 0  # test je / nie je spusteny
my_defcred_progress = 0  # vizualne zobrazenie priebehu testu
my_btn_clicks = 0  # pocet kliknuti pri poslednom stlaceni tlacidla

# vzhlad stranky
layout = dbc.Container([
    dbc.Row([
        html.H1('Sken 4 - Default Credentials test')
    ]),
    dbc.Row([
        html.Table(
            style={'marginBottom': '20px'},
            children=[
                html.Tr(
                    children=[
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja MAC adresa je:'),
                                      html.Div(className='ADResa', children=[myMAC])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja IP adresa je:'),
                                      html.Div(className='ADResa', children=[myIP])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none', 'width': '33%'},
                            children=[html.Div('Testuje sa sieť:'),
                                      html.Div(className='ADResa', children=[myIP + '/24'])])
                    ]
                )
            ]
        )
    ]),
    dbc.Row([
        html.Div(children=[html.Table(style={'marginBottom': '0px'},
                                      children=[
                                          html.Tr(children=[
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div('IP adresa zariadenia:')]),
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[dcc.Input(id='device_IP',
                                                                          value=my_defcred.get_host(),
                                                                          style={'width': 300})])
                                          ]
                                          ),
                                          html.Tr(children=[
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div('Telnet / SSH test:')]),
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[dcc.Checklist(['Telnet', 'SSH'],
                                                                              value=['Telnet', 'SSH'],
                                                                              id='test_options',
                                                                              inline=True)])
                                          ]
                                          )
                                      ]),
                           html.Table(style={'marginBottom': '0px'},
                                      children=[
                                          html.Tr(children=[
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Button(id='page4testuj',
                                                                            n_clicks=0,
                                                                            children=['TEST - START'],
                                                                            style={'margin-bottom': '10px',
                                                                                   'background-color': '#333333',
                                                                                   'color': '#ffffff'}
                                                                            )]),
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div('Testujem prihlasovacie údaje: ')]),
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div(id='page4uname',
                                                                         className='ADResa',
                                                                         children=[my_defcred.get_username()])]),
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div(id='page4psswd',
                                                                         className='ADResa',
                                                                         children=[my_defcred.get_password()])])
                                          ]
                                          )
                                      ]),
                           dcc.Input(id='page4pomocka', value='0', style={'display': 'none'}),
                           html.Div(children=[dbc.Progress(id='page4progbar', value=0, color='#1eaedb',
                                                           style={'height': '10px', 'margin-bottom': '10px'}),
                                              dcc.Interval(id='page4progbar-interval', n_intervals=0, interval=1000)])
                           ]),
        html.Div(children=[dash_table.DataTable(
            id='page4table1',
            fixed_rows={'headers': True, 'data': 0},
            columns=[{'id': 'DefCrdID', 'name': 'ID'},
                     {'id': 'IP', 'name': 'IP adresa'},
                     {'id': 'PORT', 'name': 'PORT (Služba)'},
                     {'id': 'USERNAME', 'name': 'Meno'},
                     {'id': 'PASSWORD', 'name': 'Heslo'}],
            style_table={'border': 'grey solid', 'height': 600, 'margin-bottom': '10px'},
            style_header={'color': 'lightgrey',
                          'backgroundColor': 'rgb(30,30,30)',
                          'fontWeight': 'bold'},
            style_cell={'color': 'white',
                        'backgroundColor': 'rgb(50,50,50)',
                        'border': '0px solid',
                        'font-size': '1.2em',
                        'textAlign': 'center',
                        'min-width': '70px'},
            style_as_list_view=True,
            style_data_conditional=[{'if': {'row_index': 'odd'},
                                     'backgroundColor': 'rgb(70,70,70)'}],
            page_action='none'),
            dcc.Interval(
                id='page4table1_interval',
                interval=5000,  # aktualizuje n_intervals kazdych 5s
                n_intervals=0
            )
        ])
    ])
])


# Callback funkcia pre tlacidlo - potrebna pre spravne zobrazovanie textu tlacidla pri vybere stranok
@callback(Output('page4testuj', 'children'),
          [Input('page4pomocka', 'value')])
def update_page4testuj(v):
    global my_defcred_running

    btn_text = 'TEST - END'
    if my_defcred_running == 0:
        btn_text = 'TEST - START'
    elif my_defcred_running == 1:
        btn_text = 'TEST - STOP'

    return btn_text


# Callback funkcia pre tlacidlo - "TEST - START/STOP/END"
@callback(Output('page4pomocka', 'value'),
          [Input('page4testuj', 'n_clicks'),
           Input('test_options', 'value')],
          prevent_initial_call=True)
def update_page4pomocka(n_c, test_options):
    global my_defcred
    global my_defcred_running

    btn_text = '2'
    if my_defcred_running == 0:
        print("Štart...")
        if 'Telnet' in test_options:
            my_defcred.do_telnet = 1
        else:
            my_defcred.do_telnet = 0
        if 'SSH' in test_options:
            my_defcred.do_ssh = 1
        else:
            my_defcred.do_ssh = 0

        my_defcred.start()  # spustenie testovania v samostatnom vlakne
        my_defcred_running = 1
        btn_text = '1'
    elif my_defcred_running == 1:
        print("Stop...")
        my_defcred.join(3)  # ukoncenie vlakna
        my_defcred_running = 2
        btn_text = '2'

    return btn_text


# Callback funkcia pre tabulku 1 - aktualizacia kazdych 5s
@callback(Output('page4table1', 'data'),
          [Input('page4table1_interval', 'n_intervals')])
def update_page4table1(n):
    # print(pkt_data.to_dict('records'))
    return my_defcred.get_defcred_data().to_dict('records')


# Callback funkcia pre progress bar - aktualizacia kazdu 1s
@callback([Output('page4progbar', 'value'),
           Output('page4uname', 'children'),
           Output('page4psswd', 'children')],
          [Input('page4progbar-interval', 'n_intervals')])
def update_page4progress(n):
    global my_defcred_running
    global my_defcred_progress

    if my_defcred_running == 1:
        my_defcred_progress += 25
        if my_defcred_progress > 100:
            my_defcred_progress = 0
    elif my_defcred_running == 2:
        my_defcred_progress = 0

    return [my_defcred_progress, my_defcred.get_username(), my_defcred.get_password()]
