from time import sleep

from dash import html, callback, dcc
import dash_bootstrap_components as dbc
from dash.dependencies import Input, Output
from dash import dash_table

from scapy.all import *  # Scapy
from scapy.layers.dns import DNS, DNSRR
from scapy.layers.inet import IP, UDP
from scapy.layers.l2 import Ether

import pandas as pd  # Pandas

from http.server import BaseHTTPRequestHandler, HTTPServer
from base64 import b64encode, b64decode

from Crypto.Cipher import AES  # pycryptodome
from Crypto.Util.Padding import unpad

myMAC = get_if_hwaddr(conf.iface)  # moja MAC adresa
myIP = get_if_addr(conf.iface)  # moja IP adresa

my_tunneling_running = 0  # sken je / nie je spusteny
my_tunneling_progress = 0  # vizualne zobrazenie priebehu skenu
my_btn_clicks = 0  # pocet kliknuti pri poslednom stlaceni tlacidla

# udaje prijate prostrednictvom HTTP Cookie
tunneling_HTTP_data = pd.DataFrame(columns=['id', 'TunnelingID', 'IP', 'DATA'])
tunneling_HTTP_data.set_index("id", inplace=True)
tunneling_HTTP_id = 0  # id zaznamu

# udaje prijate prostrednictvom DNS Query
tunneling_DNS_data = pd.DataFrame(columns=['id', 'TunnelingID', 'IP', 'DATA'])
tunneling_DNS_data.set_index("id", inplace=True)
tunneling_DNS_id = 0  # id zaznamu

key = b'AAAABBBBCCCCDDDD'  # kluce sa musia zhodovat !!!
iv = b'................'  # klient generuje a zasiela IV na server !!!


# desifrovanie udajov
def decrypt(data, iiv):
    cipher = AES.new(key, AES.MODE_CBC, iiv)
    padded_data = cipher.decrypt(data)
    data = unpad(padded_data, cipher.block_size, style='pkcs7')
    return data


# https://docs.python.org/3.12/library/http.server.html#http.server.HTTPServer
class myRequestHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        global tunneling_HTTP_data
        global tunneling_HTTP_id
        global iv

        # prijate udaje - klient zasiela IV + zasifrovane udaje vo formate src_ip|xxx|data"
        data = self.headers['Cookie']
        print('b64encoded IV + encrypted DATA')
        print(data)
        data = b64decode(data)  # b64 dekodovanie IV a zasifrovanych udajov
        print('IV + encrypted DATA')
        print(data)
        iv = data[0:16]  # IV = prvych 16 bytov
        print('IV')
        print(iv)
        data = data[16:]  # data = zostavajuce byty od 16-teho do konca
        print('encrypted DATA')
        print(data)
        data = decrypt(data, iv)  # udaje sa odsifruju s vyuzitim IV
        data = data.decode('utf-8')  # konverzia bytes na string
        print('decrypted DATA')
        print(data)
        
        # prijate udaje - klient zasiela udaje vo formate src_ip|xxx|data
        print('Prijal som údaje prostredníctvom HTTP Cookie: %s' % data)

        # ak je v udajoch retazec |xxx|
        if '|xxx|' in data:
            # format retazca = IP adresa klienta |xxx| udaje
            # d[0] = IP adresa klienta
            # d[1] = udaje
            d = data.split('|xxx|')

            # test ci uz v zozname existuju rovnake udaje
            exists = 0
            for i in range(0, tunneling_HTTP_id):
                if tunneling_HTTP_data.loc[i]['DATA'] == d[1]:
                    exists = 1
            # ak udaje neexistuju, doplni udaje do zoznamu
            if exists != 1:
                tunneling_HTTP_data.loc[tunneling_HTTP_id] = (tunneling_HTTP_id, d[0], d[1])
                tunneling_HTTP_id += 1  # bol pridany novy zaznam

            # klientovi je zaslana pozitivna odpoved
            response = b64encode(bytes('Údaje [%s] úspešne prijaté' % d[1], 'utf-8'))
        else:
            # klientovi je zaslana negativna odpoved
            response = b64encode(bytes('Údaje neboli prijaté', 'utf-8'))

        # zaslanie odpovede klientovi
        # prida response header - class http.server.BaseHTTPRequestHandler() vratane verzie servera a aktualneho datumu
        self.send_response(200)
        self.end_headers()  # prida blank line ukoncujuci MIME headers
        self.wfile.write(response)  # class socketserver.StreamRequestHandler()


class TunnelingHTTPServerClass(Thread):
    def __init__(self):
        super().__init__()

        self.host = '172.20.10.5'  # server IP
        self.port = 8888  # server PORT
        self.myHTTPServer = None  # HTTP server

        self.stop_thread = Event()  # pre spravne ukoncenie vlakna

    # spustenie skenovania v samostatnom vlakne
    def run(self):
        if self.stop_thread.is_set():  # ak Event is set, ukoncenie vlakna
            return

        # https://docs.python.org/3.12/library/http.server.html#http.server.HTTPServer
        self.myHTTPServer = HTTPServer((self.host, self.port), myRequestHandler)
        try:
            # class socketserver.BaseServer()
            self.myHTTPServer.serve_forever()
        except Exception as e:
            print(e)

    # ukoncenie vlakna
    def join(self, timeout=None):
        self.stop_thread.set()
        if self.myHTTPServer:
            # class socketserver.BaseServer()
            self.myHTTPServer.server_close()
        super().join(timeout)


# kompletny retazec udajov
allDNSdata = ''


def putDNSdata(query):
    dst_ip = '172.20.10.6'  # IP adresa klienta - je potrebne zmenit !!!

    question = query[DNS].qd
    answer = DNSRR(rrname=question.qname, ttl=1000, rdata=dst_ip)
    response = (Ether(src=query[Ether].dst, dst=query[Ether].src) /
                IP(src=query[IP].dst, dst=query[IP].src) /
                UDP(dport=query[UDP].sport, sport=1111) /
                DNS(id=query[DNS].id, qr=1, qdcount=1, ancount=1, qd=query[DNS].qd, an=answer))
    sendp(response)
    sleep(1)


def getDNSdata(pckt):
    global allDNSdata
    global tunneling_DNS_data
    global tunneling_DNS_id
    global iv

    # ak prijaty paket obsahuje DNS a UDP vrstvy
    if pckt.haslayer(DNS) and pckt.haslayer(UDP):
        # ak UDP port = 1111
        if pckt[UDP].dport == 1111:
            # udaje - DNS Question Record (dns.py) - DNSStrField
            data = pckt[DNS].qd.qname
            data = data[0:16]  # zasifrovane udaje = prvych 16 bytov
            # print('data')
            # print(data)
            try:
                ddata = decrypt(data, iv)  # udaje sa odsifruju s vyuzitim rovnakeho IV ako pri HTTP
                ddata = ddata.decode('utf-8')  # konverzia bytes na string
                # print('ddata')
                # print(ddata)
                # ak boli prijate vsetky casti udajov
                if ddata == '|xxx|':
                    print('Prijal som údaje prostredníctvom DNS Query: %s' % allDNSdata)

                    # test ci uz v zozname existuju rovnake udaje
                    exists = 0
                    for i in range(0, tunneling_DNS_id):
                        if tunneling_DNS_data.loc[i]['DATA'] == allDNSdata:
                            exists = 1
                    # ak udaje neexistuju, doplni udaje do zoznamu
                    if exists != 1:
                        tunneling_DNS_data.loc[tunneling_DNS_id] = (tunneling_DNS_id, pckt[IP].src, allDNSdata)
                        tunneling_DNS_id += 1  # bol pridany novy zaznam

                    allDNSdata = ''  # boli prijate vsetky casti udajov, zacina sa prijem novych casti
                    putDNSdata(pckt)  # zaslanie odpovede klientovi
                else:
                    allDNSdata += ddata  # postupne spajanie casti udajov
                    putDNSdata(pckt)  # zaslanie odpovede klientovi
            except Exception as e:
                print(e)
                putDNSdata(pckt)  # zaslanie odpovede klientovi


class TunnelingDNSServerClass(Thread):
    def __init__(self):
        super().__init__()
        self.stop_thread = Event()  # pre spravne ukoncenie vlakna

    # spustenie skenovania v samostatnom vlakne
    def run(self):
        if self.stop_thread.is_set():  # ak Event is set, ukoncenie vlakna
            return
        try:
            # Scapy sniff() - sendrecv.py
            sniff(prn=getDNSdata)
        except Exception as e:
            print(e)

    # ukoncenie vlakna
    def join(self, timeout=None):
        self.stop_thread.set()
        super().join(timeout)


my_tunnelingHTTP = TunnelingHTTPServerClass()
my_tunnelingDNS = TunnelingDNSServerClass()

# vzhlad stranky
layout = dbc.Container([
    dbc.Row([
        html.H1('Sken 6 - Príjem údajov prostredníctvom HTTP Cookie a DNS Query')
    ]),
    dbc.Row([
        html.Table(
            style={'marginBottom': '20px'},
            children=[
                html.Tr(
                    children=[
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja MAC adresa je:'),
                                      html.Div(className='ADResa', children=[myMAC])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none',
                                   'border-right': '1px solid', 'width': '33%'},
                            children=[html.Div('Moja IP adresa je:'),
                                      html.Div(className='ADResa', children=[myIP])]),
                        html.Td(
                            style={'text-align': 'center', 'border-bottom': 'none', 'width': '33%'},
                            children=[html.Div('Testuje sa sieť:'),
                                      html.Div(className='ADResa', children=[myIP + '/24'])])
                    ]
                )
            ]
        )
    ]),
    dbc.Row([
        html.Div(children=[html.Table(style={'marginBottom': '0px'},
                                      children=[
                                          html.Tr(children=[
                                              html.Td(style={'border-bottom': 'none'},
                                                      children=[html.Button(id='page6skenuj',
                                                                            n_clicks=0,
                                                                            children=['SERVER - START'],
                                                                            style={'margin-bottom': '10px',
                                                                                   'background-color': '#333333',
                                                                                   'color': '#ffffff'}
                                                                            )])
                                          ]
                                          )
                                      ]),
                           dcc.Input(id='page6pomocka', value='0', style={'display': 'none'}),
                           html.Div(children=[dbc.Progress(id='page6progbar', value=0, color='#1eaedb',
                                                           style={'height': '10px', 'margin-bottom': '10px'}),
                                              dcc.Interval(id='page6progbar-interval', n_intervals=0, interval=1000)])
                           ]),
        html.Div(children=[html.H2('Údaje prijaté prostredníctvom HTTP Cookie')]),
        html.Div(children=[dash_table.DataTable(
            id='page6table1',
            fixed_rows={'headers': True, 'data': 0},
            columns=[{'id': 'TunnelingID', 'name': 'ID'},
                     {'id': 'IP', 'name': 'IP adresa'},
                     {'id': 'DATA', 'name': 'DATA'}],
            style_table={'border': 'grey solid', 'height': 300, 'margin-bottom': '10px'},
            style_header={'color': 'lightgrey',
                          'backgroundColor': 'rgb(30,30,30)',
                          'fontWeight': 'bold'},
            style_cell={'color': 'white',
                        'backgroundColor': 'rgb(50,50,50)',
                        'border': '0px solid',
                        'font-size': '1.2em',
                        'textAlign': 'center',
                        'min-width': '70px'},
            style_as_list_view=True,
            style_data_conditional=[{'if': {'row_index': 'odd'},
                                     'backgroundColor': 'rgb(70,70,70)'}],
            page_action='none'),
            dcc.Interval(
                id='page6table1_interval',
                interval=5000,  # aktualizuje n_intervals kazdych 5s
                n_intervals=0
            )
        ]),
        html.Div(children=[html.H2('Údaje prijaté prostredníctvom DNS Query')]),
        html.Div(children=[dash_table.DataTable(
            id='page6table2',
            fixed_rows={'headers': True, 'data': 0},
            columns=[{'id': 'TunnelingID', 'name': 'ID'},
                     {'id': 'IP', 'name': 'IP adresa'},
                     {'id': 'DATA', 'name': 'DATA'}],
            style_table={'border': 'grey solid', 'height': 300, 'margin-bottom': '10px'},
            style_header={'color': 'lightgrey',
                          'backgroundColor': 'rgb(30,30,30)',
                          'fontWeight': 'bold'},
            style_cell={'color': 'white',
                        'backgroundColor': 'rgb(50,50,50)',
                        'border': '0px solid',
                        'font-size': '1.2em',
                        'textAlign': 'center',
                        'min-width': '70px'},
            style_as_list_view=True,
            style_data_conditional=[{'if': {'row_index': 'odd'},
                                     'backgroundColor': 'rgb(70,70,70)'}],
            page_action='none')
        ])
    ])
])


# Callback funkcia pre tlacidlo - potrebna pre spravne zobrazovanie textu tlacidla pri vybere stranok
@callback(Output('page6skenuj', 'children'),
          [Input('page6pomocka', 'value')])
def update_page6skenuj(v):
    global my_tunneling_running

    btn_text = 'SERVER - END'
    if my_tunneling_running == 0:
        btn_text = 'SERVER - START'
    elif my_tunneling_running == 1:
        btn_text = 'SERVER - STOP'

    return btn_text


# Callback funkcia pre tlacidlo - "SKEN - START/STOP/END"
@callback(Output('page6pomocka', 'value'),
          Input('page6skenuj', 'n_clicks'),
          prevent_initial_call=True)
def update_page6pomocka(n_c):
    global my_tunneling_running

    btn_text = '2'
    if my_tunneling_running == 0:
        print("Štart...")
        my_tunnelingHTTP.start()  # spustenie skenovania v samostatnom vlakne
        my_tunnelingDNS.start()  # spustenie skenovania v samostatnom vlakne
        my_tunneling_running = 1
        btn_text = '1'
    elif my_tunneling_running == 1:
        print("Stop...")
        my_tunnelingHTTP.join(3)  # ukoncenie vlakna
        my_tunnelingDNS.join(3)  # ukoncenie vlakna
        my_tunneling_running = 2
        btn_text = '2'

    return btn_text


# Callback funkcia pre tabulku 1 - aktualizacia kazdych 5s
@callback([Output('page6table1', 'data'),
           Output('page6table2', 'data')],
          [Input('page6table1_interval', 'n_intervals')])
def update_page6table1(n):
    return [tunneling_HTTP_data.to_dict('records'), tunneling_DNS_data.to_dict('records')]


# Callback funkcia pre progress bar - aktualizacia kazdu 1s
@callback(Output('page6progbar', 'value'),
          [Input('page6progbar-interval', 'n_intervals')])
def update_page6progress(n):
    global my_tunneling_running
    global my_tunneling_progress

    if my_tunneling_running == 1:
        my_tunneling_progress += 25
        if my_tunneling_progress > 100:
            my_tunneling_progress = 0
    elif my_tunneling_running == 2:
        my_tunneling_progress = 0

    return my_tunneling_progress
